/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.generator.processor;

import io.fabric8.common.Visitable;
import io.fabric8.common.Visitor;
import io.fabric8.kubernetes.api.model.HasKind;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.generator.annotation.KubernetesModelProcessor;
import io.fabric8.kubernetes.generator.processor.AbstractKubernetesAnnotationProcessor;
import io.fabric8.kubernetes.generator.processor.CompilationTaskFactory;
import io.fabric8.openshift.api.model.template.Template;
import io.fabric8.openshift.api.model.template.TemplateBuilder;
import io.fabric8.utils.Maps;
import io.fabric8.utils.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.inject.Named;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;

@SupportedAnnotationTypes(value={"io.fabric8.kubernetes.generator.annotation.KubernetesModelProcessor"})
public class KubernetesModelProcessorProcessor
extends AbstractKubernetesAnnotationProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        CompilationTaskFactory compilationTaskFactory = new CompilationTaskFactory(this.processingEnv);
        HashSet<TypeElement> processors = new HashSet<TypeElement>();
        for (Element element : roundEnv.getElementsAnnotatedWith(KubernetesModelProcessor.class)) {
            processors.add(this.getClassElement(element));
        }
        if (processors.isEmpty()) {
            return true;
        }
        try {
            JavaCompiler.CompilationTask compileTask = compilationTaskFactory.create(processors);
            if (!((Boolean)compileTask.call()).booleanValue()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to compile provider classes");
                return false;
            }
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to compile provider classes");
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(KubernetesModelProcessor.class)) {
            KubernetesListBuilder builder;
            HasKind json = this.readJson();
            if (json instanceof KubernetesList) {
                builder = new KubernetesListBuilder((KubernetesList)json);
            } else if (json instanceof Template) {
                builder = new TemplateBuilder((Template)json);
            } else {
                if (json != null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unknown Kubernetes json type:" + json.getClass());
                    return false;
                }
                return false;
            }
            try {
                if (element instanceof TypeElement) {
                    for (ExecutableElement methodElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
                        TypeElement classElement = this.getClassElement(element);
                        Class<?> cls = Class.forName(classElement.getQualifiedName().toString());
                        final Object instance = cls.newInstance();
                        final String methodName = methodElement.getSimpleName().toString();
                        if (builder instanceof Visitable) {
                            ((Visitable)builder).accept(new Visitor(){

                                public void visit(Object o) {
                                    for (Method m : KubernetesModelProcessorProcessor.findMethods(instance, methodName, o.getClass())) {
                                        Named named = m.getAnnotation(Named.class);
                                        if (named != null && !Strings.isNullOrBlank((String)named.value())) {
                                            String objectName = KubernetesModelProcessorProcessor.getName(o);
                                            if (!named.value().equals(objectName)) {
                                                KubernetesModelProcessorProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Named method:" + m.getName() + " with name:" + named.value() + " doesn't match: " + objectName + ", ignoring");
                                                return;
                                            }
                                        }
                                        try {
                                            m.invoke(instance, o);
                                        }
                                        catch (IllegalAccessException e) {
                                            KubernetesModelProcessorProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error invoking visitor method:" + m.getName() + " on:" + instance + "with argument:" + o);
                                        }
                                        catch (InvocationTargetException e) {
                                            KubernetesModelProcessorProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error invoking visitor method:" + m.getName() + " on:" + instance + "with argument:" + o);
                                        }
                                    }
                                }
                            });
                            continue;
                        }
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Json type is not visitable.");
                    }
                }
                json = (HasKind)builder.build();
                this.generateJson(json);
            }
            catch (Exception ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error creating Kubernetes configuration:" + ex.getMessage());
            }
        }
        return true;
    }

    private static Set<Method> findMethods(Object instance, String methodName, Class argumentType) {
        LinkedHashSet<Method> result = new LinkedHashSet<Method>();
        for (Method m : instance.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(argumentType)) continue;
            result.add(m);
        }
        return result;
    }

    private static <T, V> V getWithReflection(T object, Class<V> clazz, String methodNamed) {
        if (object == null) {
            return null;
        }
        try {
            Method method = object.getClass().getMethod(methodNamed, new Class[0]);
            return clazz.cast(method.invoke(object, new Object[0]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> String getUuid(T obj) {
        return KubernetesModelProcessorProcessor.getWithReflection(obj, String.class, "getUid");
    }

    public static <T> Map<String, Object> getAdditionalProperties(T obj) {
        return KubernetesModelProcessorProcessor.getWithReflection(obj, Map.class, "getAdditionalProperties");
    }

    public static <T> ObjectMeta getObjectMeta(T obj) {
        return KubernetesModelProcessorProcessor.getWithReflection(obj, ObjectMeta.class, "getMetadata");
    }

    public static <T> String getName(T entity) {
        if (entity != null) {
            Map<String, Object> additionalProperties = KubernetesModelProcessorProcessor.getAdditionalProperties(entity);
            return Strings.firstNonBlank((String[])new String[]{KubernetesModelProcessorProcessor.getWithReflection(entity, String.class, "getName"), KubernetesModelProcessorProcessor.getName(KubernetesModelProcessorProcessor.getObjectMeta(entity)), Maps.nestedValueAsString(additionalProperties, (String[])new String[]{"metadata", "id"}), Maps.nestedValueAsString(additionalProperties, (String[])new String[]{"metadata", "name"}), String.valueOf(additionalProperties.get("id")), KubernetesModelProcessorProcessor.getUuid(entity)});
        }
        return null;
    }
}

