/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.OutputStream;

public class ExecStdInExample {
    public static void main(String[] args) {
        String master = "https://localhost:8443/";
        String podName = null;
        if (args.length == 2) {
            master = args[0];
            podName = args[1];
        }
        if (args.length == 1) {
            podName = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(config).build();
             ExecWatch watch = ((PodResource)client.pods().withName(podName)).redirectingInput().writingOutput((OutputStream)System.out).terminateOnError().exec(new String[]{"cat"});){
            OutputStream input = watch.getInput();
            input.write("hello".getBytes());
            input.flush();
            watch.close();
            watch.exitCode().join();
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }
}

