/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder;
import io.fabric8.openshift.api.model.SecurityContextConstraintsFluent;
import io.fabric8.openshift.api.model.SecurityContextConstraintsList;
import io.fabric8.openshift.client.OpenShiftClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContextConstraintExample {
    private static final Logger logger = LoggerFactory.getLogger(SecurityContextConstraintExample.class);

    public static void main(String[] args) {
        try (OpenShiftClient client = (OpenShiftClient)new KubernetesClientBuilder().build().adapt(OpenShiftClient.class);){
            logger.info("Cluster SecurityContextConstraints:");
            ((SecurityContextConstraintsList)client.securityContextConstraints().list()).getItems().forEach(scc -> logger.info(" - {}", (Object)scc.getMetadata().getName()));
            SecurityContextConstraints scc2 = (SecurityContextConstraints)client.securityContextConstraints().create((Object)((SecurityContextConstraintsBuilder)((SecurityContextConstraintsBuilder)((SecurityContextConstraintsBuilder)((SecurityContextConstraintsFluent.SupplementalGroupsNested)((SecurityContextConstraintsBuilder)((SecurityContextConstraintsFluent.FsGroupNested)((SecurityContextConstraintsBuilder)((SecurityContextConstraintsFluent.SeLinuxContextNested)((SecurityContextConstraintsBuilder)((SecurityContextConstraintsFluent.RunAsUserNested)((SecurityContextConstraintsBuilder)((SecurityContextConstraintsBuilder)((SecurityContextConstraintsFluent.MetadataNested)new SecurityContextConstraintsBuilder().withNewMetadata().withName("scc")).endMetadata()).withAllowPrivilegedContainer(Boolean.valueOf(true))).withNewRunAsUser().withType("RunAsAny")).endRunAsUser()).withNewSeLinuxContext().withType("RunAsAny")).endSeLinuxContext()).withNewFsGroup().withType("RunAsAny")).endFsGroup()).withNewSupplementalGroups().withType("RunAsAny")).endSupplementalGroups()).addToUsers(new String[]{"admin"})).addToGroups(new String[]{"admin-group"})).build());
            logger.info("Created SecurityContextConstraints {}", (Object)scc2);
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

