/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.ParameterValue;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateExample {
    private static final Logger logger = LoggerFactory.getLogger(TemplateExample.class);
    private static final String NAMESPACE = "template-example-ns";
    private static final String TEST_TEMPLATE_RESOURCE = "/test-template.yml";
    private static final String DEFAULT_NAME_OF_TEMPLATE = "eap6-basic-sti";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try (OpenShiftClient client = (OpenShiftClient)new KubernetesClientBuilder().build().adapt(OpenShiftClient.class);){
            try {
                logger.info("Creating temporary project '{}' for example", (Object)NAMESPACE);
                client.projectrequests().create((Object)((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(NAMESPACE)).endMetadata()).build());
                logger.info("Created project: {}", (Object)NAMESPACE);
                Template loadedTemplate = (Template)((TemplateResource)client.templates().load(TemplateExample.class.getResourceAsStream(TEST_TEMPLATE_RESOURCE))).item();
                for (Parameter p : loadedTemplate.getParameters()) {
                    String required = Boolean.TRUE.equals(p.getRequired()) ? "*" : "";
                    logger.info("Loaded parameter from template: {}{} - '{}' ({})", new Object[]{p.getName(), required, p.getValue(), p.getGenerate()});
                }
                Template serverUploadedTemplate = (Template)((TemplateResource)((NonNamespaceOperation)client.templates().inNamespace(NAMESPACE)).load(TemplateExample.class.getResourceAsStream(TEST_TEMPLATE_RESOURCE))).create();
                logger.info("Template {} successfully created on server", (Object)serverUploadedTemplate.getMetadata().getName());
                Template serverDownloadedTemplate = (Template)((TemplateResource)((NonNamespaceOperation)client.templates().inNamespace(NAMESPACE)).withName(DEFAULT_NAME_OF_TEMPLATE)).get();
                logger.info("Template {} successfully downloaded from server", (Object)serverDownloadedTemplate.getMetadata().getName());
                KubernetesList processedTemplateWithDefaultParameters = ((TemplateResource)((NonNamespaceOperation)client.templates().inNamespace(NAMESPACE)).withName(DEFAULT_NAME_OF_TEMPLATE)).process(new ParameterValue[0]);
                logger.info("Template {} successfully processed to list with {} items, and requiredBoolean = {}", new Object[]{((HasMetadata)processedTemplateWithDefaultParameters.getItems().get(0)).getMetadata().getLabels().get("template"), processedTemplateWithDefaultParameters.getItems().size(), ((HasMetadata)processedTemplateWithDefaultParameters.getItems().get(0)).getMetadata().getLabels().get("requiredBoolean")});
                KubernetesList processedTemplateWithCustomParameters = ((TemplateResource)((NonNamespaceOperation)client.templates().inNamespace(NAMESPACE)).withName(DEFAULT_NAME_OF_TEMPLATE)).process(Collections.singletonMap("REQUIRED_BOOLEAN", "true"));
                logger.info("Template {} successfully processed to list with {} items, and requiredBoolean = {}", new Object[]{((HasMetadata)processedTemplateWithCustomParameters.getItems().get(0)).getMetadata().getLabels().get("template"), processedTemplateWithCustomParameters.getItems().size(), ((HasMetadata)processedTemplateWithCustomParameters.getItems().get(0)).getMetadata().getLabels().get("requiredBoolean")});
                List l = client.load(TemplateExample.class.getResourceAsStream("/test-list.yml")).items();
                logger.info("{}", (Object)l.size());
                boolean templateDeleted = ((TemplateResource)((NonNamespaceOperation)client.templates().inNamespace(NAMESPACE)).withName(DEFAULT_NAME_OF_TEMPLATE)).delete().size() == 1;
                logger.info("Template {} was {}deleted", (Object)DEFAULT_NAME_OF_TEMPLATE, (Object)(templateDeleted ? "" : "**NOT** "));
                ((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.load(TemplateExample.class.getResourceAsStream("/test-list.yml")).inNamespace(NAMESPACE)).create();
            }
            finally {
                ((Resource)client.projects().withName(NAMESPACE)).delete();
                logger.info("Deleted project {}", (Object)NAMESPACE);
            }
        }
    }
}

