/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.api.model.storage.StorageClassBuilder;
import io.fabric8.kubernetes.api.model.storage.StorageClassFluent;
import io.fabric8.kubernetes.api.model.storage.StorageClassList;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageClassExamples {
    private static final Logger logger = LoggerFactory.getLogger(StorageClassExamples.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
            logger.info("Using master with URL: {}", (Object)args[0]);
        }
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(configBuilder.build()).build();){
            String storageClassName = UUID.randomUUID().toString();
            logger.info("List of existent storage classes:");
            ((StorageClassList)client.storage().v1().storageClasses().list()).getItems().forEach(sc -> logger.info(" - {}", (Object)sc.getMetadata().getName()));
            logger.info("Creating new Storage class");
            StorageClass storageClass = (StorageClass)client.storage().v1().storageClasses().create((Object)((StorageClassBuilder)((StorageClassBuilder)((StorageClassBuilder)((StorageClassBuilder)((StorageClassBuilder)((StorageClassBuilder)((StorageClassBuilder)((StorageClassFluent.MetadataNested)new StorageClassBuilder().withNewMetadata().withName(storageClassName)).endMetadata()).addToParameters("resturl", "http://localhost:8080")).addToParameters("restuser", "")).addToParameters("secretNamespace", "")).addToParameters("secretName", "")).addToParameters("key", "value1")).withProvisioner("k8s.io/minikube-hostpath")).build());
            logger.info("Newly created storage class details:\n{}", (Object)storageClass);
            logger.info("Updated list of existent storage classes:");
            ((StorageClassList)client.storage().v1().storageClasses().list()).getItems().forEach(sc -> logger.info(" - {}", (Object)sc.getMetadata().getName()));
            logger.info("Updating {} storage clas to add new label", (Object)storageClassName);
            StorageClass updatedStorageClass = (StorageClass)((Resource)client.storage().v1().storageClasses().withName(storageClassName)).edit(s -> ((StorageClassBuilder)((StorageClassFluent.MetadataNested)new StorageClassBuilder(s).editMetadata().addToLabels("testLabel", "testLabelValue")).endMetadata()).build());
            logger.info("Updated storage class details:\n{}", (Object)updatedStorageClass);
            client.resource((HasMetadata)storageClass).delete();
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

