/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapExample {
    private static final Logger logger = LoggerFactory.getLogger(ConfigMapExample.class);

    public static void main(String[] args) {
        Config config = new ConfigBuilder().build();
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(config).build();){
            String namespace = null;
            if (args.length > 0) {
                namespace = args[0];
            }
            if (namespace == null) {
                namespace = client.getNamespace();
            }
            if (namespace == null) {
                namespace = "default";
            }
            String name = "cheese";
            Resource configMapResource = (Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(name);
            ConfigMap configMap = (ConfigMap)configMapResource.createOrReplace((Object)((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(name)).endMetadata()).addToData("foo", "" + new Date())).addToData("bar", "beer")).build());
            logger.info("Upserted ConfigMap at {} data {}", (Object)configMap.getMetadata().getSelfLink(), (Object)configMap.getData());
        }
    }
}

