/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceValidationFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.io.Serializable;

public class CustomResourceV1Example {
    public static void main(String ... args) {
        try (DefaultKubernetesClient kc = new DefaultKubernetesClient();){
            CustomResourceDefinition crd = ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.VersionsNested)((CustomResourceDefinitionVersionFluent.SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)CustomResourceDefinitionContext.v1CRDFromCustomResourceType(Show.class).editSpec().editVersion(Integer.valueOf(0)).withNewSchema().withNewOpenAPIV3Schema().withTitle("Shows")).withType("object")).addToRequired(new String[]{"spec"})).addToProperties("spec", ((JSONSchemaPropsBuilder)((JSONSchemaPropsBuilder)((JSONSchemaPropsBuilder)new JSONSchemaPropsBuilder().withType("object")).addToProperties("name", ((JSONSchemaPropsBuilder)new JSONSchemaPropsBuilder().withType("string")).build())).addToProperties("score", ((JSONSchemaPropsBuilder)new JSONSchemaPropsBuilder().withType("number")).build())).build())).endOpenAPIV3Schema()).endSchema()).endVersion()).endSpec()).build();
            kc.apiextensions().v1().customResourceDefinitions().createOrReplace((Object[])new CustomResourceDefinition[]{crd});
            System.out.println("Created custom shows.example.com Kubernetes API");
            NonNamespaceOperation shows = (NonNamespaceOperation)kc.customResources(Show.class, ShowList.class).inNamespace("default");
            shows.list();
            shows.createOrReplace((Object[])new Show[]{new Show("breaking-bad", new ShowSpec("Breaking Bad", 10))});
            shows.createOrReplace((Object[])new Show[]{new Show("better-call-saul", new ShowSpec("Better call Saul", 8))});
            shows.createOrReplace((Object[])new Show[]{new Show("the-wire", new ShowSpec("The Wire", 10))});
            System.out.println("Added three shows");
            ((ShowList)((Object)shows.list())).getItems().forEach(s -> System.out.printf(" - %s%n", ((ShowSpec)s.getSpec()).name));
            Show theWire = (Show)((Object)((Gettable)((Resource)shows.withName("the-wire")).fromServer()).get());
            System.out.printf("The Wire Score is: %s%n", ((ShowSpec)theWire.getSpec()).score);
        }
    }

    public static final class ShowSpec
    implements Serializable {
        private static final long serialVersionUID = -1548881019086449848L;
        private String name;
        private Number score;

        public ShowSpec() {
        }

        public ShowSpec(String name, int score) {
            this.name = name;
            this.score = score;
        }

        public String getName() {
            return this.name;
        }

        public Number getScore() {
            return this.score;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setScore(Number score) {
            this.score = score;
        }
    }

    public static final class ShowList
    extends CustomResourceList<Show> {
    }

    @Group(value="example.com")
    @Version(value="v1")
    public static final class Show
    extends CustomResource<ShowSpec, Void>
    implements Namespaced {
        public Show() {
        }

        public Show(String metaName, ShowSpec spec) {
            this.setMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(metaName)).build());
            this.setSpec(spec);
        }
    }
}

