/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples.kubectl.equivalents;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceListEquivalent {
    private static final Logger logger = LoggerFactory.getLogger(NamespaceListEquivalent.class);

    public static void main(String[] args) {
        logger.info("Creating Kuberntes client");
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            logger.info("Kubernetes client successfully created");
            ((NamespaceList)client.namespaces().list()).getItems().stream().map(Namespace::getMetadata).map(ObjectMeta::getName).forEach(arg_0 -> ((Logger)logger).info(arg_0));
        }
        catch (KubernetesClientException aException) {
            logger.error("Problem encountered in Kubernetes Client");
            aException.printStackTrace();
        }
    }
}

