/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.batch.JobList;
import io.fabric8.kubernetes.client.APIGroupNotAvailableException;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceQuotaExample {
    private static final Logger logger = LoggerFactory.getLogger(NamespaceQuotaExample.class);
    private static final String NAMESPACE = "namepsace-test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block15: {
            ConfigBuilder configBuilder = new ConfigBuilder();
            if (args.length > 0) {
                configBuilder.withMasterUrl(args[0]);
            }
            try (DefaultKubernetesClient client = new DefaultKubernetesClient(configBuilder.build());){
                String namespace = NAMESPACE;
                if (args.length > 2) {
                    namespace = args[2];
                }
                try {
                    Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(namespace)).addToLabels("hello", "world")).endMetadata()).build();
                    logger.info("Created namespace: {}", (Object)((Namespace)client.namespaces().create((Object)ns)).getMetadata().getName());
                    logger.info("Get namespace by name: {}", ((Resource)client.namespaces().withName(namespace)).get());
                    logger.info("Get namespace by label:");
                    ((NamespaceList)((FilterWatchListDeletable)client.namespaces().withLabel("hello", "world")).list()).getItems().forEach(n -> logger.info(" - {}", (Object)n.getMetadata().getName()));
                    ResourceQuota quota = (ResourceQuota)((NonNamespaceOperation)client.resourceQuotas().inNamespace(namespace)).createOrReplace((Object[])new ResourceQuota[]{((ResourceQuotaBuilder)((ResourceQuotaFluent.SpecNested)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName("quota-example")).endMetadata()).withNewSpec().addToHard("pods", new Quantity("5"))).endSpec()).build()});
                    logger.info("Create resource quota: {}", (Object)quota.getMetadata().getName());
                    try {
                        logger.info("Listing jobs in namespace");
                        ((JobList)((NonNamespaceOperation)client.batch().jobs().inNamespace(namespace)).list()).getItems().forEach(j -> logger.info(" - {}", (Object)j.getMetadata().getName()));
                    }
                    catch (APIGroupNotAvailableException e) {
                        logger.warn("Skipping jobs example - extensions API group not available");
                    }
                }
                finally {
                    ((Resource)client.namespaces().withName(namespace)).delete();
                    logger.info("Deleted namespace: {}", (Object)namespace);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                Throwable[] suppressed = e.getSuppressed();
                if (suppressed == null) break block15;
                for (Throwable t : suppressed) {
                    logger.error(t.getMessage(), t);
                }
            }
        }
    }
}

