/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentExamples {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentExamples.class);
    private static final String NAMESPACE = "this-is-a-test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(NAMESPACE)).addToLabels("this", "rocks")).endMetadata()).build();
            logger.info("Created namespace: {}", client.namespaces().createOrReplace((Object[])new Namespace[]{ns}));
            ServiceAccount fabric8 = ((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName("fabric8")).endMetadata()).build();
            ((NonNamespaceOperation)client.serviceAccounts().inNamespace(NAMESPACE)).createOrReplace((Object[])new ServiceAccount[]{fabric8});
            try {
                Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("nginx")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().addToLabels("app", "nginx")).endMetadata()).withNewSpec().addNewContainer().withName("nginx")).withImage("nginx")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).withNewSelector().addToMatchLabels("app", "nginx")).endSelector()).endSpec()).build();
                deployment = (Deployment)((NonNamespaceOperation)client.apps().deployments().inNamespace(NAMESPACE)).create((Object)deployment);
                logger.info("Created deployment: {}", (Object)deployment);
                logger.info("Scaling up: {}", (Object)deployment.getMetadata().getName());
                ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(NAMESPACE)).withName("nginx")).scale(2, true);
                logger.info("Created replica sets: {}", (Object)((ReplicaSetList)((NonNamespaceOperation)client.apps().replicaSets().inNamespace(NAMESPACE)).list()).getItems());
                logger.info("Deleting: {}", (Object)deployment.getMetadata().getName());
                client.resource((HasMetadata)deployment).delete();
            }
            finally {
                ((Resource)client.namespaces().withName(NAMESPACE)).delete();
            }
            logger.info("Done.");
        }
    }
}

