/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.settings.PodPreset;
import io.fabric8.kubernetes.api.model.settings.PodPresetBuilder;
import io.fabric8.kubernetes.api.model.settings.PodPresetFluent;
import io.fabric8.kubernetes.api.model.settings.PodPresetSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodPresetExamples {
    private static final Logger logger = LoggerFactory.getLogger(PodPresetExamples.class);

    public static void main(String[] args) {
        String master = "https://192.168.42.193:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            String namespace = "default";
            PodPresetExamples.log("namespace", namespace);
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).load(PodPresetExamples.class.getResourceAsStream("/pod-preset-example.yml"))).get();
            PodPresetExamples.log("Pod created");
            ((NonNamespaceOperation)client.pods().inNamespace(namespace)).create((Object[])new Pod[]{pod});
            PodPreset podPreset = ((PodPresetBuilder)((PodPresetFluent.SpecNested)((PodPresetFluent.SpecNested)((PodPresetFluent.SpecNested)((PodPresetFluent.SpecNested)((PodPresetSpecFluent.SelectorNested)((PodPresetBuilder)((PodPresetFluent.MetadataNested)new PodPresetBuilder().withNewMetadata().withName("allow-database")).endMetadata()).withNewSpec().withNewSelector().withMatchLabels(Collections.singletonMap("role", "frontend"))).endSelector()).withEnv(new EnvVar[]{((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("DB_PORT")).withValue("6379")).build()})).withVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/cache")).withName("cache-volume")).build()})).withVolumes(new Volume[]{((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("cache-volume")).withEmptyDir(new EmptyDirVolumeSourceBuilder().build())).build()})).endSpec()).build();
            PodPresetExamples.log("Creating Pod Preset : " + podPreset.getMetadata().getName());
            ((NonNamespaceOperation)client.settings().podPresets().inNamespace(namespace)).create((Object[])new PodPreset[]{podPreset});
            pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(pod.getMetadata().getName())).get();
            PodPresetExamples.log("Updated pod: ");
            PodPresetExamples.log(SerializationUtils.dumpAsYaml((HasMetadata)pod));
        }
        catch (Exception e) {
            PodPresetExamples.log("Exception occurred: ", e.getMessage());
            e.printStackTrace();
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

