/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.kubernetes.examples.crds.Dummy;
import io.fabric8.kubernetes.examples.crds.DummyList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomResourceInformerExample {
    private static final Logger logger = LoggerFactory.getLogger(CustomResourceInformerExample.class);

    public static void main(String[] args) {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            CustomResourceDefinitionContext crdContext = new CustomResourceDefinitionContext.Builder().withVersion("v1").withScope("Namespaced").withGroup("demo.fabric8.io").withPlural("dummies").build();
            SharedInformerFactory sharedInformerFactory = client.informers();
            SharedIndexInformer podInformer = sharedInformerFactory.sharedIndexInformerForCustomResource(crdContext, Dummy.class, DummyList.class, 900000L);
            logger.info("Informer factory initialized.");
            podInformer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<Dummy>(){

                public void onAdd(Dummy pod) {
                    System.out.printf("%s dummy added\n", pod.getMetadata().getName());
                }

                public void onUpdate(Dummy oldPod, Dummy newPod) {
                    System.out.printf("%s dummy updated\n", oldPod.getMetadata().getName());
                }

                public void onDelete(Dummy pod, boolean deletedFinalStateUnknown) {
                    System.out.printf("%s dummy deleted \n", pod.getMetadata().getName());
                }
            });
            logger.info("Starting all registered informers");
            sharedInformerFactory.startAllRegisteredInformers();
            TimeUnit.MINUTES.sleep(15L);
        }
        catch (InterruptedException interruptedException) {
            logger.info("interrupted: {}", (Object)interruptedException.getMessage());
        }
    }
}

