/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.scheduling.PriorityClass;
import io.fabric8.kubernetes.api.model.scheduling.PriorityClassBuilder;
import io.fabric8.kubernetes.api.model.scheduling.PriorityClassFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.examples.PodDisruptionBudgetExample;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodPriorityExample {
    private static final Logger logger = LoggerFactory.getLogger(PodDisruptionBudgetExample.class);

    public static void main(String[] args) throws InterruptedException {
        String master = "https://192.168.99.100:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        PodPriorityExample.log("Using master with url ", master);
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            PriorityClass priorityClass = ((PriorityClassBuilder)((PriorityClassBuilder)((PriorityClassBuilder)((PriorityClassBuilder)((PriorityClassFluent.MetadataNested)new PriorityClassBuilder().withNewMetadata().withName("high-priority")).endMetadata()).withValue(new Integer(100000))).withGlobalDefault(Boolean.valueOf(false))).withDescription("This priority class should be used for XYZ service pods only.")).build();
            client.scheduling().priorityClass().create((Object)priorityClass);
            ((NonNamespaceOperation)client.pods().inNamespace("default")).create((Object)((PodBuilder)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("nginx")).withLabels(Collections.singletonMap("env", "test"))).endMetadata()).withNewSpec().addToContainers(new Container[]{((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("nginx")).withImage("nginx")).withImagePullPolicy("IfNotPresent")).build()})).withPriorityClassName("high-priority")).endSpec()).build());
        }
        catch (KubernetesClientException e) {
            e.printStackTrace();
            PodPriorityExample.log("Could not create resource", e.getMessage());
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

