/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagBuilder;
import io.fabric8.openshift.api.model.ImageStreamTagFluent;
import io.fabric8.openshift.api.model.ImageStreamTagList;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageStreamTagExample {
    private static final Logger logger = LoggerFactory.getLogger(ImageStreamTagExample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        String namespace = "myproject";
        String master = "CLUSTER_URL";
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        DefaultOpenShiftClient client = new DefaultOpenShiftClient(config);
        try {
            ImageStreamTag istag = ((ImageStreamTagBuilder)((ImageStreamTagFluent.TagNested)((TagReferenceFluent.FromNested)((TagReferenceFluent.FromNested)((ImageStreamTagBuilder)((ImageStreamTagFluent.MetadataNested)new ImageStreamTagBuilder().withNewMetadata().withName("bar1:1.0.12")).endMetadata()).withNewTag().withNewFrom().withKind("DockerImage")).withName("openshift/wildfly-81-centos7:latest")).endFrom()).endTag()).build();
            ImageStreamTagExample.log("Created istag", ((NonNamespaceOperation)client.imageStreamTags().inNamespace(namespace)).create((Object)istag));
            Thread.sleep(30000L);
        }
        finally {
            ImageStreamTagExample.log("ImageStreamTags are :");
            ImageStreamTagExample.log(((ImageStreamTag)((Resource)((NonNamespaceOperation)client.imageStreamTags().inNamespace(namespace)).withName("bar1:1.0.12")).get()).toString());
            ImageStreamTagExample.log("ImageStreamTags using list are :");
            ImageStreamTagExample.log(((ImageStreamTag)((ImageStreamTagList)client.imageStreamTags().list()).getItems().get(0)).toString());
            ImageStreamTagExample.log("Deleted istag", ((Resource)client.imageStreamTags().withName("bar1:1.0.12")).delete());
            client.close();
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

