/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawCustomResourceExample {
    private static final Logger logger = LoggerFactory.getLogger(RawCustomResourceExample.class);

    public static void main(String[] args) throws Exception {
        final CountDownLatch closeLatch = new CountDownLatch(1);
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            String namespace = "default";
            CustomResourceDefinition prometheousRuleCrd = (CustomResourceDefinition)((Resource)client.customResourceDefinitions().load(RawCustomResourceExample.class.getResourceAsStream("/prometheous-rule-crd.yml"))).get();
            client.customResourceDefinitions().create((Object)prometheousRuleCrd);
            RawCustomResourceExample.log("Successfully created prometheous custom resource definition");
            CustomResourceDefinitionContext crdContext = new CustomResourceDefinitionContext.Builder().withGroup("monitoring.coreos.com").withPlural("prometheusrules").withScope("Namespaced").withVersion("v1").build();
            client.customResource(crdContext).create(namespace, RawCustomResourceExample.class.getResourceAsStream("/prometheous-rule-cr.yml"));
            RawCustomResourceExample.log("Created Custom Resource successfully too");
            Map list = client.customResource(crdContext).list(namespace);
            List items = (List)list.get("items");
            RawCustomResourceExample.log("Custom Resources :- ");
            for (Map customResource : items) {
                Map metadata = (Map)customResource.get("metadata");
                RawCustomResourceExample.log(metadata.get("name").toString());
            }
            RawCustomResourceExample.log("Watching custom resources now");
            client.customResource(crdContext).watch(namespace, (Watcher)new Watcher<String>(){

                public void eventReceived(Watcher.Action action, String resource) {
                    logger.info("{}: {}", (Object)action, (Object)resource);
                }

                public void onClose(KubernetesClientException e) {
                    logger.debug("Watcher onClose");
                    closeLatch.countDown();
                    if (e != null) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            closeLatch.await(10L, TimeUnit.MINUTES);
            RawCustomResourceExample.log("Deleting custom resources...");
            Map deleted = client.customResource(crdContext).delete(namespace, "prometheus-example-rules");
            ((Resource)client.customResourceDefinitions().withName("prometheusrules.monitoring.coreos.com")).delete();
        }
        catch (KubernetesClientException e) {
            e.printStackTrace();
            RawCustomResourceExample.log("Could not create resource", e.getMessage());
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

