/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.List;
import org.junit.Assert;

public class ListDeploymentConfigs {
    public static void main(String[] args) {
        try {
            DefaultOpenShiftClient client = new DefaultOpenShiftClient();
            if (!client.supportsOpenShiftAPIGroup("apps.openshift.io")) {
                System.out.println("WARNING this cluster does not support the API Group apps.openshift.io");
                return;
            }
            DeploymentConfigList list = (DeploymentConfigList)client.deploymentConfigs().list();
            if (list == null) {
                System.out.println("ERROR no list returned!");
                return;
            }
            List items = list.getItems();
            for (DeploymentConfig item : items) {
                System.out.println("DeploymentConfig " + item.getMetadata().getName() + " has version: " + item.getApiVersion());
            }
            if (items.size() > 0) {
                DeploymentConfig deploymentConfig = (DeploymentConfig)items.get(0);
                String name = deploymentConfig.getMetadata().getName();
                deploymentConfig = (DeploymentConfig)((DeployableScalableResource)client.deploymentConfigs().withName(name)).get();
                Assert.assertNotNull((String)("No DeploymentConfig found for name " + name), (Object)deploymentConfig);
                System.out.println("get() DeploymentConfig " + name + " has version: " + deploymentConfig.getApiVersion());
            }
        }
        catch (KubernetesClientException e) {
            System.out.println("Failed: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }
}

