/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.examples.crds.DoneableDummy;
import io.fabric8.kubernetes.examples.crds.Dummy;
import io.fabric8.kubernetes.examples.crds.DummyList;
import io.fabric8.kubernetes.examples.crds.DummySpec;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRDExample {
    private static final Logger logger = LoggerFactory.getLogger(CRDExample.class);
    public static String DUMMY_CRD_GROUP = "demo.fabric8.io";
    public static String DUMMY_CRD_NAME = "dummies." + DUMMY_CRD_GROUP;
    private static boolean logRootPaths = false;

    public static void main(String[] args) {
        String namespace = null;
        if (args.length > 0) {
            namespace = args[0];
        }
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            List paths;
            RootPaths rootPaths;
            if (namespace == null) {
                namespace = client.getNamespace();
            }
            if (namespace == null) {
                System.err.println("No namespace specified and no default defined!");
                return;
            }
            System.out.println("Using namespace: " + namespace);
            if (logRootPaths && (rootPaths = client.rootPaths()) != null && (paths = rootPaths.getPaths()) != null) {
                System.out.println("Supported API Paths:");
                for (Object path : paths) {
                    System.out.println("    " + (String)path);
                }
                System.out.println();
            }
            CustomResourceDefinitionList crds = (CustomResourceDefinitionList)client.customResourceDefinitions().list();
            List crdsItems = crds.getItems();
            System.out.println("Found " + crdsItems.size() + " CRD(s)");
            CustomResourceDefinition dummyCRD = null;
            for (CustomResourceDefinition crd : crdsItems) {
                ObjectMeta metadata = crd.getMetadata();
                if (metadata == null) continue;
                String name = metadata.getName();
                System.out.println("    " + (String)name + " => " + metadata.getSelfLink());
                if (!DUMMY_CRD_NAME.equals(name)) continue;
                dummyCRD = crd;
            }
            if (dummyCRD != null) {
                System.out.println("Found CRD: " + dummyCRD.getMetadata().getSelfLink());
            } else {
                dummyCRD = ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)((CustomResourceDefinitionBuilder)new CustomResourceDefinitionBuilder().withApiVersion("apiextensions.k8s.io/v1beta1")).withNewMetadata().withName(DUMMY_CRD_NAME)).endMetadata()).withNewSpec().withGroup(DUMMY_CRD_GROUP)).withVersion("v1")).withScope("Namespaced")).withNewNames().withKind("Dummy")).withShortNames(new String[]{"dummy"})).withPlural("dummies")).endNames()).endSpec()).build();
                client.customResourceDefinitions().create((Object[])new CustomResourceDefinition[]{dummyCRD});
                System.out.println("Created CRD " + dummyCRD.getMetadata().getName());
            }
            NonNamespaceOperation dummyClient = (NonNamespaceOperation)client.customResource(dummyCRD, Dummy.class, DummyList.class, DoneableDummy.class).inNamespace(namespace);
            CustomResourceList dummyList = (CustomResourceList)dummyClient.list();
            List items = dummyList.getItems();
            System.out.println("  found " + items.size() + " dummies");
            for (Dummy item : items) {
                System.out.println("    " + (Object)((Object)item));
            }
            Dummy dummy = new Dummy();
            ObjectMeta metadata = new ObjectMeta();
            metadata.setName("foo");
            dummy.setMetadata(metadata);
            DummySpec dummySpec = new DummySpec();
            Date now = new Date();
            dummySpec.setBar("beer: " + now);
            dummySpec.setFoo("cheese: " + now);
            dummy.setSpec(dummySpec);
            dummyClient.createOrReplace((Object[])new Dummy[]{dummy});
            System.out.println("Upserted " + (Object)((Object)dummy));
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

