/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchExample {
    private static final Logger logger = LoggerFactory.getLogger(WatchExample.class);

    public static void main(String[] args) throws InterruptedException {
        block45: {
            String master = "http://localhost:8080/";
            if (args.length == 1) {
                master = args[0];
            }
            final CountDownLatch closeLatch = new CountDownLatch(1);
            EditableConfig config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).withWatchReconnectLimit(2)).build();
            try (DefaultKubernetesClient client = new DefaultKubernetesClient((Config)config);){
                Throwable throwable;
                Watch watch;
                try {
                    watch = (Watch)((ClientRollableScallableResource)((ClientNonNamespaceOperation)client.replicationControllers().inNamespace("default")).withName("test")).watch((Object)new Watcher<ReplicationController>(){

                        public void eventReceived(Watcher.Action action, ReplicationController resource) {
                            logger.info("{}: {}", (Object)action, (Object)resource.getMetadata().getResourceVersion());
                        }

                        public void onClose(KubernetesClientException e) {
                            if (e != null) {
                                logger.error(e.getMessage(), (Throwable)e);
                                closeLatch.countDown();
                            }
                        }
                    });
                    throwable = null;
                    try {
                        closeLatch.await(10L, TimeUnit.SECONDS);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (watch != null) {
                            if (throwable != null) {
                                try {
                                    watch.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                watch.close();
                            }
                        }
                    }
                }
                catch (KubernetesClientException | InterruptedException e) {
                    logger.error("Could not watch resources", e);
                }
                try {
                    watch = (Watch)((ClientNonNamespaceOperation)client.replicationControllers().inNamespace("default")).watch((Object)new Watcher<ReplicationController>(){

                        public void eventReceived(Watcher.Action action, ReplicationController resource) {
                            logger.info("{}: {}", (Object)action, (Object)resource.getMetadata().getResourceVersion());
                        }

                        public void onClose(KubernetesClientException e) {
                            if (e != null) {
                                logger.error(e.getMessage(), (Throwable)e);
                                closeLatch.countDown();
                            }
                        }
                    });
                    throwable = null;
                    try {
                        closeLatch.await(10L, TimeUnit.SECONDS);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (watch != null) {
                            if (throwable != null) {
                                try {
                                    watch.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                watch.close();
                            }
                        }
                    }
                }
                catch (KubernetesClientException | InterruptedException e) {
                    logger.error("Could not watch resources", e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
                Throwable[] suppressed = e.getSuppressed();
                if (suppressed == null) break block45;
                for (Throwable t : suppressed) {
                    logger.error(t.getMessage(), t);
                }
            }
        }
    }
}

