/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodLogExample {
    private static final Logger logger = LoggerFactory.getLogger(PodLogExample.class);

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: podName [master] [namespace]");
            return;
        }
        String podName = args[0];
        String namespace = "default";
        String master = "https://localhost:8443/";
        if (args.length > 1) {
            master = args[1];
        }
        if (args.length > 2) {
            namespace = args[2];
        }
        System.out.println("Log of pod " + podName + " in " + namespace + " is:");
        System.out.println("----------------------------------------------------------------");
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient((Config)config);
             LogWatch watch = (LogWatch)((PrettyLoggable)((ClientPodResource)((ClientNonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).tailingLines(10)).watchLog((OutputStream)System.out);){
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

