/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.Callback;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecPipesExample {
    public static void main(String[] args) throws InterruptedException, IOException {
        String master = "https://localhost:8443/";
        String podName = null;
        if (args.length == 2) {
            master = args[0];
            podName = args[1];
        }
        if (args.length == 1) {
            podName = args[0];
        }
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient((Config)config);
             ExecWatch watch = (ExecWatch)((TtyExecErrorable)((TtyExecOutputErrorable)((ClientPodResource)client.pods().withName(podName)).redirectingInput()).redirectingOutput()).exec((Object[])new String[0]);
             InputStreamPumper pump = new InputStreamPumper(watch.getOutput(), (Callback)new SystemOutCallback());){
            executorService.submit((Runnable)pump);
            watch.getInput().write("ls -al\n".getBytes());
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private static class SystemOutCallback
    implements Callback<byte[]> {
        private SystemOutCallback() {
        }

        public void call(byte[] data) {
            System.out.print(new String(data));
        }
    }
}

