/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteExamples {
    private static final Logger logger = LoggerFactory.getLogger(DeleteExamples.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        DefaultKubernetesClient client = new DefaultKubernetesClient((Config)config);
        try {
            DeleteExamples.log("Create namespace:", client.namespaces().create((Object[])new Namespace[]{((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName("thisisatest")).endMetadata()).build()}));
            DeleteExamples.log("Deleted namespace:", ((ClientResource)client.namespaces().withName("test")).delete());
            DeleteExamples.log("Deleted testPod:", ((ClientPodResource)((ClientNonNamespaceOperation)client.pods().inNamespace("thisisatest")).withName("testpod")).delete());
            DeleteExamples.log("Deleted pod by label:", ((FilterWatchListDeletable)client.pods().withLabel("this", "works")).delete());
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ((ClientResource)client.namespaces().withName("thisisatest")).delete();
            client.close();
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

