/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class GenerateKindToClassMap {
    public static void main(String[] args) throws Exception {
        String[] topLevelPackages;
        ClassPath classPath = ClassPath.from((ClassLoader)GenerateKindToClassMap.class.getClassLoader());
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        for (String topLevelPackage : topLevelPackages = new String[]{"io.fabric8.kubernetes.api.model", "io.fabric8.openshift.api.model"}) {
            ImmutableSet classInfos = classPath.getTopLevelClassesRecursive(topLevelPackage);
            for (ClassPath.ClassInfo classInfo : classInfos) {
                String string = classInfo.getSimpleName();
                if (string.endsWith("Builder") || string.endsWith("Fluent")) continue;
                sortedMap.put(string, classInfo.getName());
            }
        }
        String basedir = System.getProperty("basedir", ".");
        File file = new File(basedir, "../kubernetes-api/src/main/java/io/fabric8/kubernetes/api/support/KindToClassMapping.java");
        file.getParentFile().mkdirs();
        System.out.println("Generating " + file);
        TreeSet classNames = new TreeSet(sortedMap.values());
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));){
            Set entries = sortedMap.entrySet();
            writer.println("/**\n * Licensed to the Apache Software Foundation (ASF) under one or more\n * contributor license agreements.  See the NOTICE file distributed with\n * this work for additional information regarding copyright ownership.\n * The ASF licenses this file to You under the Apache License, Version 2.0\n * (the \"License\"); you may not use this file except in compliance with\n * the License.  You may obtain a copy of the License at\n * <p/>\n * http://www.apache.org/licenses/LICENSE-2.0\n * <p/>\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\npackage io.fabric8.kubernetes.api.support;\n\n");
            for (String string : classNames) {
                writer.println("import " + string + ";");
            }
            writer.println("\nimport java.util.HashMap;\nimport java.util.Map;\n\n/**\n * Maps the Kubernetes kinds to the Jackson DTO classes\n */\npublic class KindToClassMapping {\n    private static Map<String,Class<?>> map = new HashMap<>();\n\n    static {");
            for (Map.Entry entry : entries) {
                String kind = (String)entry.getKey();
                String className = (String)entry.getValue();
                writer.println("        map.put(\"" + kind + "\", " + kind + ".class);");
            }
            writer.println("    }\n\n    public static Map<String,Class<?>> getKindToClassMap() {\n        return map;\n    }\n}\n");
        }
    }
}

