/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.impl.cache;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.impl.cache.ProcessorListener;
import junit.framework.TestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ProcessorListenerTest {
    private boolean addNotificationReceived;
    private boolean updateNotificationReceived;
    private boolean deleteNotificationReceived;

    ProcessorListenerTest() {
    }

    @Test
    void testNotificationHandling() {
        final Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("foo")).withNamespace("default")).endMetadata()).build();
        ProcessorListener listener = new ProcessorListener((ResourceEventHandler)new ResourceEventHandler<Pod>(){

            public void onAdd(Pod obj) {
                Assertions.assertEquals((Object)pod, (Object)obj);
                ProcessorListenerTest.this.addNotificationReceived = true;
            }

            public void onUpdate(Pod oldObj, Pod newObj) {
                Assertions.assertEquals((Object)pod, (Object)newObj);
                ProcessorListenerTest.this.updateNotificationReceived = true;
            }

            public void onDelete(Pod obj, boolean deletedFinalStateUnknown) {
                Assertions.assertEquals((Object)pod, (Object)obj);
                ProcessorListenerTest.this.deleteNotificationReceived = true;
            }
        }, 0L);
        listener.add((ProcessorListener.Notification)new ProcessorListener.AddNotification((Object)pod));
        listener.add((ProcessorListener.Notification)new ProcessorListener.UpdateNotification(null, (Object)pod));
        listener.add((ProcessorListener.Notification)new ProcessorListener.DeleteNotification((Object)pod));
        TestCase.assertTrue((boolean)this.addNotificationReceived);
        TestCase.assertTrue((boolean)this.updateNotificationReceived);
        TestCase.assertTrue((boolean)this.deleteNotificationReceived);
    }
}

