/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PodOperationsImplTest {
    private PodOperationsImpl podOperations;

    PodOperationsImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.podOperations = new PodOperationsImpl(new PodOperationContext(), new OperationContext());
    }

    @Test
    void validateOrDefaultContainerIdDefaultName() {
        Pod pod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod-1")).endMetadata()).withNewSpec().addNewContainer().withName("a")).endContainer()).addNewContainer().withName("b")).endContainer()).endSpec()).build();
        Assertions.assertEquals((Object)"a", (Object)this.podOperations.validateOrDefaultContainerId(null, pod));
        pod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(pod).editMetadata().addToAnnotations("kubectl.kubernetes.io/default-container", "b")).endMetadata()).build();
        Assertions.assertEquals((Object)"b", (Object)this.podOperations.validateOrDefaultContainerId(null, pod));
        pod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(pod).editMetadata().addToAnnotations("kubectl.kubernetes.io/default-container", "c")).endMetadata()).build();
        Assertions.assertEquals((Object)"a", (Object)this.podOperations.validateOrDefaultContainerId(null, pod));
    }

    @Test
    void validateOrDefaultContainerIdDefaultNameEmptyContainers() {
        Pod pod = new Pod();
        Assertions.assertThrows(KubernetesClientException.class, () -> this.podOperations.validateOrDefaultContainerId(null, pod));
        pod.setSpec(new PodSpec());
        pod.getSpec().setContainers(null);
        Assertions.assertThrows(KubernetesClientException.class, () -> this.podOperations.validateOrDefaultContainerId(null, pod));
        pod.setSpec(new PodSpec());
        Assertions.assertThrows(KubernetesClientException.class, () -> this.podOperations.validateOrDefaultContainerId(null, pod));
    }

    @Test
    void validateOrDefaultContainerIdByName() {
        Pod pod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.EphemeralContainersNested)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodFluent.SpecNested)((PodSpecFluent.InitContainersNested)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod-1")).endMetadata()).withNewSpec().addNewInitContainer().withName("a")).endInitContainer()).addNewContainer().withName("b")).endContainer()).addNewEphemeralContainer().withName("c")).endEphemeralContainer()).endSpec()).build();
        Assertions.assertEquals((Object)"a", (Object)this.podOperations.validateOrDefaultContainerId("a", pod));
        Assertions.assertEquals((Object)"b", (Object)this.podOperations.validateOrDefaultContainerId("b", pod));
        Assertions.assertEquals((Object)"c", (Object)this.podOperations.validateOrDefaultContainerId("c", pod));
        Assertions.assertThrows(KubernetesClientException.class, () -> this.podOperations.validateOrDefaultContainerId("d", pod));
    }

    @Test
    void validateOrDefaultContainerIdByNameEmptyContainers() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod-1")).endMetadata()).build();
        pod.setSpec(null);
        Assertions.assertThrows(KubernetesClientException.class, () -> this.podOperations.validateOrDefaultContainerId("a", pod));
        pod.setSpec(new PodSpec());
        pod.getSpec().setContainers(null);
        pod.getSpec().setEphemeralContainers(null);
        Assertions.assertThrows(KubernetesClientException.class, () -> this.podOperations.validateOrDefaultContainerId("a", pod));
        pod.setSpec(new PodSpec());
        Assertions.assertThrows(KubernetesClientException.class, () -> this.podOperations.validateOrDefaultContainerId("a", pod));
    }
}

