/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManagerTest;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.WatchHTTPManager;
import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.TestHttpResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class WatchHttpManagerTest {
    WatchHttpManagerTest() {
    }

    @Test
    void testReconnectOnException() throws MalformedURLException, InterruptedException {
        CompletableFuture<HttpResponse<AsyncBody>> future = new CompletableFuture<HttpResponse<AsyncBody>>();
        CountDownLatch reconnect = new CountDownLatch(1);
        this.setupHttpWatch(future, reconnect);
        future.completeExceptionally(new IOException());
        Assertions.assertTrue((boolean)reconnect.await(1L, TimeUnit.SECONDS));
    }

    @Test
    void testReconnectOnFailedResponse() throws MalformedURLException, InterruptedException {
        CompletableFuture<HttpResponse<AsyncBody>> future = new CompletableFuture<HttpResponse<AsyncBody>>();
        CountDownLatch reconnect = new CountDownLatch(1);
        this.setupHttpWatch(future, reconnect);
        AsyncBody mockBody = (AsyncBody)Mockito.mock(AsyncBody.class);
        future.complete((HttpResponse<AsyncBody>)new TestHttpResponse().withCode(429).withBody((Object)mockBody));
        ((AsyncBody)Mockito.verify((Object)mockBody)).cancel();
        Assertions.assertTrue((boolean)reconnect.await(1L, TimeUnit.SECONDS));
    }

    @Test
    void testNoReconnectOnHttpGone() throws MalformedURLException, InterruptedException {
        CompletableFuture<HttpResponse<AsyncBody>> future = new CompletableFuture<HttpResponse<AsyncBody>>();
        CountDownLatch reconnect = new CountDownLatch(1);
        this.setupHttpWatch(future, reconnect);
        AsyncBody mockBody = (AsyncBody)Mockito.mock(AsyncBody.class);
        future.complete((HttpResponse<AsyncBody>)new TestHttpResponse().withCode(410).withBody((Object)mockBody));
        ((AsyncBody)Mockito.verify((Object)mockBody)).cancel();
        Assertions.assertFalse((boolean)reconnect.await(1L, TimeUnit.SECONDS));
    }

    private void setupHttpWatch(CompletableFuture<HttpResponse<AsyncBody>> future, final CountDownLatch reconnect) throws MalformedURLException {
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        BaseOperation baseOperation = AbstractWatchManagerTest.mockOperation();
        Mockito.when((Object)baseOperation.getNamespacedUrl()).thenReturn((Object)new URL("http://localhost"));
        Mockito.when((Object)client.consumeBytes((HttpRequest)Mockito.any(), (AsyncBody.Consumer)Mockito.any())).thenReturn(future);
        WatchHTTPManager watch = new WatchHTTPManager(client, baseOperation, (ListOptions)Mockito.mock(ListOptions.class), (Watcher)Mockito.mock(Watcher.class), 1, 0){

            void scheduleReconnect(AbstractWatchManager.WatchRequestState state) {
                reconnect.countDown();
            }
        };
    }
}

