/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManagerTest;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.WebSocket;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class WatchConnectionManagerTest {
    WatchConnectionManagerTest() {
    }

    @Test
    void testNoReconnectOnException() throws MalformedURLException, InterruptedException {
        CompletableFuture<WebSocket> future = new CompletableFuture<WebSocket>();
        CountDownLatch reconnect = new CountDownLatch(1);
        this.setupWebSocketWatch(future, reconnect);
        future.completeExceptionally(new IOException());
        Assertions.assertFalse((boolean)reconnect.await(1L, TimeUnit.SECONDS));
    }

    @Test
    void testReconnectOnException() throws MalformedURLException, InterruptedException {
        CompletableFuture<WebSocket> future = new CompletableFuture<WebSocket>();
        CountDownLatch reconnect = new CountDownLatch(1);
        WatchConnectionManager<?, ?> manager = this.setupWebSocketWatch(future, reconnect);
        manager.ready = true;
        future.completeExceptionally(new IOException());
        Assertions.assertTrue((boolean)reconnect.await(1L, TimeUnit.SECONDS));
    }

    @Test
    void testCloseRequest() throws MalformedURLException, InterruptedException {
        CompletableFuture<WebSocket> future = new CompletableFuture<WebSocket>();
        CountDownLatch reconnect = new CountDownLatch(1);
        WatchConnectionManager<?, ?> manager = this.setupWebSocketWatch(future, reconnect);
        WebSocket mock = (WebSocket)Mockito.mock(WebSocket.class);
        future.complete(mock);
        AbstractWatchManager.WatchRequestState state = manager.latestRequestState;
        manager.closeRequest();
        ((WebSocket)Mockito.verify((Object)mock)).sendClose(1000, null);
        Assertions.assertSame((Object)state, (Object)manager.latestRequestState);
        Assertions.assertFalse((boolean)manager.latestRequestState.ended.isDone());
    }

    @Test
    void testExceptionalCloseRequest() throws MalformedURLException, InterruptedException {
        CompletableFuture<WebSocket> future = new CompletableFuture<WebSocket>();
        CountDownLatch reconnect = new CountDownLatch(1);
        WatchConnectionManager<?, ?> manager = this.setupWebSocketWatch(future, reconnect);
        WebSocket mock = (WebSocket)Mockito.mock(WebSocket.class);
        future.complete(mock);
        AbstractWatchManager.WatchRequestState state = manager.latestRequestState;
        manager.watchEnded((Throwable)new IOException(), state);
        Assertions.assertTrue((boolean)state.ended.isDone());
        Assertions.assertTrue((boolean)reconnect.await(1L, TimeUnit.SECONDS));
    }

    @Test
    void testFailSafeReconnect() throws MalformedURLException, InterruptedException {
        CompletableFuture<WebSocket> future = new CompletableFuture<WebSocket>();
        CountDownLatch reconnect = new CountDownLatch(1);
        WatchConnectionManager<?, ?> manager = this.setupWebSocketWatch(future, reconnect);
        WebSocket mock = (WebSocket)Mockito.mock(WebSocket.class);
        future.complete(mock);
        AbstractWatchManager.WatchRequestState state = manager.latestRequestState;
        manager.setWatchEndCheckMs(0);
        manager.closeRequest();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> state != manager.latestRequestState);
    }

    private WatchConnectionManager<?, ?> setupWebSocketWatch(CompletableFuture<WebSocket> future, final CountDownLatch reconnect) throws MalformedURLException {
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        BaseOperation baseOperation = AbstractWatchManagerTest.mockOperation();
        Mockito.when((Object)baseOperation.getNamespacedUrl()).thenReturn((Object)new URL("http://localhost"));
        WebSocket.Builder mockBuilder = (WebSocket.Builder)Mockito.mock(WebSocket.Builder.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)client.newWebSocketBuilder()).thenReturn((Object)mockBuilder);
        Mockito.when((Object)mockBuilder.buildAsync((WebSocket.Listener)Mockito.any())).thenReturn(future);
        return new WatchConnectionManager(client, baseOperation, (ListOptions)Mockito.mock(ListOptions.class), (Watcher)Mockito.mock(Watcher.class), 0, 0, 0L){

            void scheduleReconnect(AbstractWatchManager.WatchRequestState state) {
                reconnect.countDown();
            }
        };
    }
}

