/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.impl;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.impl.BaseClient;
import io.fabric8.kubernetes.client.impl.Handlers;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class HandlersTest {
    @Test
    public void testRegister() {
        Handlers handlers = new Handlers();
        handlers.register(MyPod.class, MyPodOperationsImpl::new);
        BaseClient mock = (BaseClient)Mockito.mock(BaseClient.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)((BaseClient)mock.adapt(BaseClient.class)).getHandlers()).thenReturn((Object)handlers);
        Assertions.assertThat((Object)handlers.get((HasMetadata)new MyPod(), null).operation((Client)mock, null)).isInstanceOf(MyPodOperationsImpl.class);
        handlers.unregister(MyPod.class);
        Assertions.assertThat((Object)handlers.get((HasMetadata)new MyPod(), null).operation((Client)mock, null)).isInstanceOf(HasMetadataOperationsImpl.class);
    }

    static class MyPodOperationsImpl
    extends HasMetadataOperation<MyPod, KubernetesResourceList<MyPod>, Resource<MyPod>> {
        public MyPodOperationsImpl(Client client) {
            super(new OperationContext().withClient(client), MyPod.class, null);
        }
    }

    static class MyPod
    extends Pod {
        MyPod() {
        }
    }
}

