/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.impl;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.ServiceToURLProvider;
import io.fabric8.kubernetes.client.impl.URLFromEnvVarsImpl;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class URLFromEnvVarsImplTest {
    private URLFromEnvVarsImpl urlFromEnvVars;
    private KubernetesClient kubernetesClient;

    URLFromEnvVarsImplTest() {
    }

    @BeforeEach
    void setup() {
        this.urlFromEnvVars = new URLFromEnvVarsImpl();
        this.kubernetesClient = (KubernetesClient)Mockito.mock(KubernetesClient.class);
    }

    @Test
    void getURL_whenNothingProvided_thenReturnNull() {
        Service svc = this.createNewServiceBuilder().build();
        String url = this.urlFromEnvVars.getURL(svc, "test", "default", this.kubernetesClient);
        AssertionsForInterfaceTypes.assertThat((String)url).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void getURL_whenServicePropertyProvided_thenReturnServiceUrl() {
        String hostProperty = "SVC1_SERVICE_HOST";
        String portProperty = "SVC1_SERVICE_PORT";
        String protocolProperty = "SVC1_SERVICE_PORT_80_TCP_PROTO";
        try {
            System.setProperty("SVC1_SERVICE_HOST", "10.111.30.220");
            System.setProperty("SVC1_SERVICE_PORT", "80");
            System.setProperty("SVC1_SERVICE_PORT_80_TCP_PROTO", "tcp");
            Service svc = this.createNewServiceBuilder().build();
            String url = this.urlFromEnvVars.getURL(svc, "test", "default", this.kubernetesClient);
            AssertionsForInterfaceTypes.assertThat((String)url).isEqualTo("tcp://10.111.30.220:80");
        }
        finally {
            System.clearProperty("SVC1_SERVICE_HOST");
            System.clearProperty("SVC1_SERVICE_PORT");
            System.clearProperty("SVC1_SERVICE_PORT_80_TCP_PROTO");
        }
    }

    @Test
    void getURL_whenServiceExposeAnnotationProvided_thenReturnServiceUrl() {
        Service svc = ((ServiceBuilder)((ServiceFluent.MetadataNested)this.createNewServiceBuilder().editMetadata().addToAnnotations("fabric8.io/exposeUrl", "http://example.com/svc1")).endMetadata()).build();
        String url = this.urlFromEnvVars.getURL(svc, "test", "default", this.kubernetesClient);
        AssertionsForInterfaceTypes.assertThat((String)url).isEqualTo("http://example.com/svc1");
    }

    @Test
    void getPriority_whenInvoked_shouldReturnThird() {
        AssertionsForInterfaceTypes.assertThat((int)this.urlFromEnvVars.getPriority()).isEqualTo(ServiceToURLProvider.ServiceToUrlImplPriority.THIRD.getValue());
    }

    private ServiceBuilder createNewServiceBuilder() {
        return (ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).withNewSpec().addNewPort().withName("test")).withProtocol("TCP")).withPort(Integer.valueOf(80))).endPort()).endSpec();
    }
}

