/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.impl;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.TestHttpResponse;
import io.fabric8.kubernetes.client.impl.KubernetesClientImpl;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class PatchTest {
    private HttpClient mockClient;
    private KubernetesClient kubernetesClient;
    private List<HttpRequest.Builder> builders;

    PatchTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.builders = new ArrayList<HttpRequest.Builder>();
        this.mockClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)Mockito.eq(byte[].class))).thenReturn(CompletableFuture.completedFuture(TestHttpResponse.from((int)200, (String)"{}")));
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://localhost:8443/")).build();
        this.kubernetesClient = new KubernetesClientImpl(this.mockClient, config, () -> Runnable::run, new KubernetesSerialization());
        Mockito.when((Object)this.mockClient.newHttpRequestBuilder()).thenAnswer(answer -> {
            HttpRequest.Builder result = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            Mockito.when((Object)result.build()).thenReturn((Object)new StandardHttpRequest.Builder().uri("https://localhost:8443/").build());
            this.builders.add(result);
            return result;
        });
    }

    @AfterEach
    public void tearDown() {
        this.kubernetesClient.close();
        this.kubernetesClient = null;
    }

    @Test
    void testJsonPatch() {
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch("{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/pods/foo", null, "application/strategic-merge-patch+json");
    }

    @Test
    void testJsonMergePatch() {
        PatchContext patchContext = new PatchContext.Builder().withPatchType(PatchType.JSON_MERGE).build();
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch(patchContext, "{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/pods/foo", null, "application/merge-patch+json");
    }

    @Test
    void testYamlPatchConvertedToJson() {
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch("metadata:\n  annotations:\n    bob: martin");
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/pods/foo", null, "application/strategic-merge-patch+json");
    }

    @Test
    void testPatchThrowExceptionWhenResourceNotFound() {
        Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)Mockito.eq(byte[].class))).thenReturn(CompletableFuture.completedFuture(new TestHttpResponse().withCode(404)));
        PodResource podResource = (PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo");
        KubernetesClientException e = (KubernetesClientException)Assertions.assertThrows(KubernetesClientException.class, () -> {
            Pod cfr_ignored_0 = (Pod)podResource.patch("{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        });
        ((HttpClient)Mockito.verify((Object)this.mockClient)).sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        Assertions.assertEquals((int)404, (int)e.getCode());
    }

    @Test
    void testJsonPatchWithPositionalArrays() {
        PatchContext patchContext = new PatchContext.Builder().withPatchType(PatchType.JSON).build();
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch(patchContext, "[{\"op\": \"replace\", \"path\":\"/spec/containers/0/image\", \"value\":\"foo/gb-frontend:v4\"}]");
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/pods/foo", null, "application/json-patch+json");
    }

    @Test
    void testPatchWithPatchOptions() {
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch(new PatchContext.Builder().withFieldManager("fabric8").withDryRun(Collections.singletonList("All")).build(), "{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest("GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/pods/foo", "fieldManager=fabric8&dryRun=All", "application/strategic-merge-patch+json");
    }

    @Test
    void testServerSideApplyWithPatchOptions() {
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).resource((Object)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).endMetadata()).build())).fieldManager("x").forceConflicts().serverSideApply();
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest(0, "PATCH", "/api/v1/namespaces/ns1/pods/pod1", "fieldManager=x&force=true", PatchType.SERVER_SIDE_APPLY.getContentType());
    }

    @Test
    void testResourceListServerSideApply() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("default")).endMetadata()).build();
        Service svc = ((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).build();
        ((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.kubernetesClient.resourceList(new HasMetadata[]{pod, svc}).inNamespace("ns1")).fieldManager("x").forceConflicts().serverSideApply();
        ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        this.assertRequest(0, "PATCH", "/api/v1/namespaces/ns1/pods/pod1", "fieldManager=x&force=true", PatchType.SERVER_SIDE_APPLY.getContentType());
        this.assertRequest(1, "PATCH", "/api/v1/namespaces/ns1/services/svc1", "fieldManager=x&force=true", PatchType.SERVER_SIDE_APPLY.getContentType());
    }

    private void assertRequest(String method, String url, String queryParam) {
        this.assertRequest(0, method, url, queryParam, null);
    }

    private void assertRequest(int index, String method, String url, String queryParam, String contentType) {
        ArgumentCaptor urlCaptor = ArgumentCaptor.forClass(URL.class);
        HttpRequest.Builder mock = this.builders.get(index);
        ((HttpRequest.Builder)Mockito.verify((Object)mock)).url((URL)urlCaptor.capture());
        URL capturedURL = (URL)urlCaptor.getValue();
        Assertions.assertEquals((Object)url, (Object)capturedURL.getPath());
        PatchTest.validateMethod(method, contentType, mock);
        Assertions.assertEquals((Object)queryParam, (Object)capturedURL.getQuery());
    }

    static void validateMethod(String method, String contentType, HttpRequest.Builder mock) {
        ArgumentCaptor contentTypeCaptor = ArgumentCaptor.forClass(String.class);
        switch (method) {
            case "DELETE": {
                ((HttpRequest.Builder)Mockito.verify((Object)mock)).delete((String)contentTypeCaptor.capture(), (String)ArgumentMatchers.any());
                break;
            }
            case "POST": {
                ((HttpRequest.Builder)Mockito.verify((Object)mock)).post((String)contentTypeCaptor.capture(), (String)ArgumentMatchers.any(String.class));
                break;
            }
            case "PUT": {
                ((HttpRequest.Builder)Mockito.verify((Object)mock)).put((String)contentTypeCaptor.capture(), (String)ArgumentMatchers.any());
                break;
            }
            case "PATCH": {
                ((HttpRequest.Builder)Mockito.verify((Object)mock)).patch((String)contentTypeCaptor.capture(), (String)ArgumentMatchers.any());
                break;
            }
        }
        if (contentType != null) {
            Assertions.assertEquals((Object)contentType, (Object)contentTypeCaptor.getValue());
        }
    }
}

