/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.authentication.TokenRequest;
import io.fabric8.kubernetes.api.model.authentication.TokenRequestBuilder;
import io.fabric8.kubernetes.api.model.authentication.TokenRequestFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientFactory;
import java.net.URISyntaxException;
import java.util.Collection;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableAssertAlternative;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ServiceAccountOperationsImplTest {
    private TestStandardHttpClientFactory factory;
    private KubernetesClient client;

    ServiceAccountOperationsImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.factory = new TestStandardHttpClientFactory();
        this.client = new KubernetesClientBuilder().withConfig(Config.empty()).withHttpClientFactory((HttpClient.Factory)this.factory).build();
    }

    @Test
    void tokenRequest_whenApiServerCallSuccessful_thenReturnTokenInTokenRequestStatus() throws URISyntaxException {
        String responseFromServer = "{\"kind\":\"TokenRequest\",\"apiVersion\":\"authentication.k8s.io/v1\",\"status\":{\"token\":\"my.secret.token\",\"expirationTimestamp\":\"2023-06-14T18:42:15Z\"}}";
        this.factory.expect("/api/v1/namespaces/test/serviceaccounts/my-serviceaccount/token", 200, "{\"kind\":\"TokenRequest\",\"apiVersion\":\"authentication.k8s.io/v1\",\"status\":{\"token\":\"my.secret.token\",\"expirationTimestamp\":\"2023-06-14T18:42:15Z\"}}");
        TokenRequest tokenRequest = ((TokenRequestBuilder)((TokenRequestFluent.SpecNested)new TokenRequestBuilder().withNewSpec().withAudiences(new String[]{"http://example.svc"})).endSpec()).build();
        TokenRequest updatedTokenRequest = ((ServiceAccountResource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace("test")).withName("my-serviceaccount")).tokenRequest(tokenRequest);
        ((ObjectAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Collection)this.factory.getInstances()).singleElement()).extracting(TestStandardHttpClient::getRecordedConsumeBytesDirects).asList().hasSize(1)).singleElement()).extracting("request").extracting("uri").asString().endsWith((CharSequence)"/api/v1/namespaces/test/serviceaccounts/my-serviceaccount/token");
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)updatedTokenRequest).hasFieldOrPropertyWithValue("status.token", (Object)"my.secret.token")).hasFieldOrPropertyWithValue("status.expirationTimestamp", (Object)"2023-06-14T18:42:15Z");
    }

    @Test
    void tokenRequest_whenApiServerRequestFailure_thenThrowException() {
        String responseFromServer = "{\"kind\":\"Status\",\"apiVersion\":\"v1\",\"status\":\"Failure\",\"message\":\"serviceaccount my-serviceaccount not found\",\"reason\":\"NotFound\",\"details\":{\"name\":\"my-service-account\",\"kind\":\"serviceaccounts\"},\"code\":404}";
        this.factory.expect("/api/v1/namespaces/test/serviceaccounts/my-serviceaccount/token", 404, "{\"kind\":\"Status\",\"apiVersion\":\"v1\",\"status\":\"Failure\",\"message\":\"serviceaccount my-serviceaccount not found\",\"reason\":\"NotFound\",\"details\":{\"name\":\"my-service-account\",\"kind\":\"serviceaccounts\"},\"code\":404}");
        ServiceAccountResource serviceAccountResource = (ServiceAccountResource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace("test")).withName("my-serviceaccount");
        ((ThrowableAssertAlternative)((ThrowableAssertAlternative)((ThrowableAssertAlternative)AssertionsForClassTypes.assertThatExceptionOfType(KubernetesClientException.class).isThrownBy(() -> ((ServiceAccountResource)serviceAccountResource).tokenRequest()).withMessageContaining("serviceaccount my-serviceaccount not found").hasFieldOrPropertyWithValue("code", (Object)404)).hasFieldOrPropertyWithValue("status.code", (Object)404)).hasFieldOrPropertyWithValue("status.message", (Object)"serviceaccount my-serviceaccount not found")).hasFieldOrPropertyWithValue("status.reason", (Object)"NotFound");
    }
}

