/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.internal;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.internal.OptionalDependencyWrapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OptionalDependencyWrapperTest {
    OptionalDependencyWrapperTest() {
    }

    @Test
    void testWrapRunWithOptionalDependencyHasAllDependenciesShouldNotThrowException() {
        boolean result = (Boolean)OptionalDependencyWrapper.wrapRunWithOptionalDependency(() -> true, (String)"I have no optional dependencies");
        Assertions.assertThat((boolean)result).isEqualTo(true);
    }

    @Test
    void testWrapRunWithOptionalDependencyUsesDependencyShouldThrowException() {
        KubernetesClientException exception = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> OptionalDependencyWrapper.wrapRunWithOptionalDependency(() -> {
            throw new NoClassDefFoundError("com.1337.invalid.IDontExist");
        }, (String)"IDontExist class is provided by some optional package"));
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("IDontExist class is provided by some optional package, an optional dependency. To use this functionality you must explicitly add this dependency to the classpath.");
    }
}

