/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.client.dsl.internal.PatchUtils;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PatchUtilsTest {
    PatchUtilsTest() {
    }

    @Test
    void testOmitStatus() {
        ReplicationController rc = ((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)new ReplicationControllerBuilder().withNewStatus().withFullyLabeledReplicas(Integer.valueOf(1))).endStatus()).withNewMetadata().withName("x")).endMetadata()).build();
        Assertions.assertEquals((Object)"---\napiVersion: \"v1\"\nkind: \"ReplicationController\"\nmetadata:\n  name: \"x\"\nstatus:\n  fullyLabeledReplicas: 1\n", (Object)PatchUtils.withoutRuntimeState((Object)rc, (PatchUtils.Format)PatchUtils.Format.YAML, (boolean)false, (KubernetesSerialization)new KubernetesSerialization()));
        Assertions.assertEquals((Object)"{\"apiVersion\":\"v1\",\"kind\":\"ReplicationController\",\"metadata\":{\"name\":\"x\"}}", (Object)PatchUtils.withoutRuntimeState((Object)rc, (PatchUtils.Format)PatchUtils.Format.JSON, (boolean)true, (KubernetesSerialization)new KubernetesSerialization()));
    }

    @Test
    void testDiff() {
        ReplicationController rc1 = ((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)new ReplicationControllerBuilder().withNewStatus().withFullyLabeledReplicas(Integer.valueOf(1))).endStatus()).withNewMetadata().withName("x")).endMetadata()).build();
        ReplicationController rc2 = ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder(rc1).editMetadata().addToLabels("my", "label")).endMetadata()).editStatus().withAvailableReplicas(Integer.valueOf(2))).endStatus()).build();
        Assertions.assertEquals((Object)"[{\"op\":\"add\",\"path\":\"/metadata/labels\",\"value\":{\"my\":\"label\"}},{\"op\":\"add\",\"path\":\"/status/availableReplicas\",\"value\":2}]", (Object)PatchUtils.jsonDiff((Object)rc1, (Object)rc2, (boolean)false, (KubernetesSerialization)new KubernetesSerialization()));
    }
}

