/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.api.model.StatusCause;
import io.fabric8.kubernetes.api.model.StatusFluent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.ExecWebSocketListener;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;

class ExecWebSocketListenerTest {
    ExecWebSocketListenerTest() {
    }

    @Test
    void testParseExitCodeSuccess() {
        Assertions.assertEquals((int)0, (int)ExecWebSocketListener.parseExitCode((Status)((StatusBuilder)new StatusBuilder().withStatus("Success")).build()));
    }

    @Test
    void testParseExitCodeInvalid() {
        Assertions.assertEquals((int)-1, (int)ExecWebSocketListener.parseExitCode((Status)((StatusBuilder)new StatusBuilder().withStatus("don't know")).build()));
    }

    @Test
    void testParseExitCodeNonZeroInvalid() {
        Assertions.assertEquals((int)-1, (int)ExecWebSocketListener.parseExitCode((Status)((StatusBuilder)((StatusBuilder)new StatusBuilder().withStatus("Failed")).withReason("NonZeroExitCode")).build()));
    }

    @Test
    void testParseExitCodeNonZero() {
        Assertions.assertEquals((int)126, (int)ExecWebSocketListener.parseExitCode((Status)((StatusBuilder)((StatusFluent.DetailsNested)((StatusBuilder)((StatusBuilder)new StatusBuilder().withStatus("Failed")).withReason("NonZeroExitCode")).withNewDetails().withCauses(new StatusCause[]{new StatusCause("ExitCode", "126", "ExitCode")})).endDetails()).build()));
    }

    @Test
    void testSendShouldTruncateAndSendFlaggedWebSocketData() {
        WebSocket mockedWebSocket = (WebSocket)Mockito.mock(WebSocket.class);
        Mockito.when((Object)mockedWebSocket.send((ByteBuffer)Mockito.any())).thenReturn((Object)true);
        ExecWebSocketListener listner = this.newExecWebSocketListener(new PodOperationContext());
        listner.onOpen(mockedWebSocket);
        byte[] toSend = new byte[]{1, 3, 3, 7, 0};
        listner.sendWithErrorChecking(toSend, 0, 4);
        ((WebSocket)Mockito.verify((Object)mockedWebSocket, (VerificationMode)VerificationModeFactory.times((int)1))).send(ByteBuffer.wrap(new byte[]{0, 1, 3, 3, 7}));
    }

    @Test
    void testCheckErrorHasErrorFromMessageShouldThrowException() {
        ExecWebSocketListener listener = this.newExecWebSocketListener(new PodOperationContext().toBuilder().terminateOnError(true).build());
        listener.onMessage(null, ByteBuffer.wrap(new byte[]{2, 1, 1}));
        Assertions.assertThrows(KubernetesClientException.class, () -> listener.checkError());
    }

    @Test
    void testCheckErrorHasErrorFromFailureShouldThrowException() {
        ExecWebSocketListener listener = this.newExecWebSocketListener(new PodOperationContext());
        listener.onError(null, (Throwable)new IOException("here"));
        Assertions.assertThrows(KubernetesClientException.class, () -> listener.checkError());
    }

    private ExecWebSocketListener newExecWebSocketListener(PodOperationContext context) {
        return new ExecWebSocketListener(context, Runnable::run, new KubernetesSerialization());
    }

    @Test
    void testGracefulClose() {
        ExecWebSocketListener listener = this.newExecWebSocketListener(new PodOperationContext());
        WebSocket mock = (WebSocket)Mockito.mock(WebSocket.class);
        listener.onOpen(mock);
        listener.close();
        Assertions.assertFalse((boolean)listener.exitCode().isDone());
        ((WebSocket)Mockito.verify((Object)mock)).sendClose(Mockito.anyInt(), Mockito.anyString());
    }

    @Test
    void testOnClose() {
        ExecWebSocketListener listener = this.newExecWebSocketListener(new PodOperationContext());
        WebSocket mock = (WebSocket)Mockito.mock(WebSocket.class);
        listener.onClose(mock, 1000, "testing");
        Assertions.assertNull(listener.exitCode().join());
    }
}

