/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.behavior;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.RequestConfigBuilder;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.TestAsyncBody;
import io.fabric8.kubernetes.client.http.TestHttpResponse;
import io.fabric8.kubernetes.client.http.TestStandardHttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientFactory;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.http.WebSocketUpgradeResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractDurationAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@DisplayName(value="Request Timeout Behavior")
class RequestTimeoutTest {
    private TestStandardHttpClientFactory factory;
    private KubernetesClient client;

    RequestTimeoutTest() {
    }

    @BeforeEach
    void setUp() {
        this.factory = new TestStandardHttpClientFactory();
        this.client = new KubernetesClientBuilder().withHttpClientFactory((HttpClient.Factory)this.factory).build();
    }

    @DisplayName(value="Standard Kubernetes Object operations have default timeout")
    @Test
    void standardOperationsHaveDefaultTimeout() {
        ((TestStandardHttpClient)this.factory.getInstances().iterator().next()).expect("/api/v1/namespaces/.+/pods.+", (HttpResponse)new TestHttpResponse().withCode(200).withBody((Object)new TestAsyncBody()));
        ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace("default")).withName("foo")).get();
        ((AbstractDurationAssert)((ObjectAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Collection)this.factory.getInstances()).singleElement()).extracting(TestStandardHttpClient::getRecordedConsumeBytesDirects).asList().hasSize(1)).singleElement()).extracting("request").extracting("timeout").asInstanceOf(InstanceOfAssertFactories.DURATION)).hasSeconds(10L);
    }

    @DisplayName(value="Standard Kubernetes Object operations, with overridden request config, have overridden timeout")
    @Test
    void standardOperationsWithOverriddenRequestConfig() {
        KubernetesClient derivedClient = (KubernetesClient)this.client.newClient(((RequestConfigBuilder)new RequestConfigBuilder().withRequestTimeout(1337000)).build());
        this.factory.getInstance(1).expect("/api/v1/namespaces/.+/pods.+", (HttpResponse)new TestHttpResponse().withCode(200).withBody((Object)new TestAsyncBody()));
        ((PodResource)((NonNamespaceOperation)derivedClient.pods().inNamespace("default")).withName("foo")).get();
        ((AbstractDurationAssert)((ObjectAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Collection)this.factory.getInstances()).element(1)).extracting(TestStandardHttpClient::getRecordedConsumeBytesDirects).asList().hasSize(1)).singleElement()).extracting("request").extracting("timeout").asInstanceOf(InstanceOfAssertFactories.DURATION)).hasSeconds(1337L);
    }

    @DisplayName(value="Standard Kubernetes Object operations, with overridden config, have overridden timeout")
    @Test
    void standardOperationsWithOverriddenConfig() {
        KubernetesClient derivedClient = new KubernetesClientBuilder().withHttpClientFactory((HttpClient.Factory)this.factory).withConfig(((ConfigBuilder)new ConfigBuilder(this.client.getConfiguration()).withRequestTimeout(1337000)).build()).build();
        this.factory.getInstance(1).expect("/api/v1/namespaces/.+/pods.+", (HttpResponse)new TestHttpResponse().withCode(200).withBody((Object)new TestAsyncBody()));
        ((PodResource)((NonNamespaceOperation)derivedClient.pods().inNamespace("default")).withName("foo")).get();
        ((AbstractDurationAssert)((ObjectAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Collection)this.factory.getInstances()).element(1)).extracting(TestStandardHttpClient::getRecordedConsumeBytesDirects).asList().hasSize(1)).singleElement()).extracting("request").extracting("timeout").asInstanceOf(InstanceOfAssertFactories.DURATION)).hasSeconds(1337L);
    }

    @DisplayName(value="Standard Kubernetes Object operations, with overridden config, have overridden timeout")
    @Test
    void standardOperationsHaveOverriddenTimeoutInConfig() {
        ((TestStandardHttpClient)this.factory.getInstances().iterator().next()).expect("/api/v1/namespaces/.+/pods.+", (HttpResponse)new TestHttpResponse().withCode(200).withBody((Object)new TestAsyncBody()));
        this.client.getConfiguration().getRequestConfig().setRequestTimeout(1337000);
        ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace("default")).withName("foo")).get();
        ((AbstractDurationAssert)((ObjectAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Collection)this.factory.getInstances()).singleElement()).extracting(TestStandardHttpClient::getRecordedConsumeBytesDirects).asList().hasSize(1)).singleElement()).extracting("request").extracting("timeout").asInstanceOf(InstanceOfAssertFactories.DURATION)).hasSeconds(1337L);
    }

    @DisplayName(value="Standard Kubernetes Object operations, withRequestConfig, derives a client (new instance) with the overridden request configuration timeout")
    @Test
    void standardOperationsHaveOverriddenTimeoutWithRequestConfig() {
        ((NamespacedKubernetesClient)this.client.adapt(NamespacedKubernetesClient.class)).withRequestConfig(((RequestConfigBuilder)new RequestConfigBuilder().withRequestTimeout(3000)).build()).call(c -> {
            this.factory.getInstance(1).expect("/api/v1/namespaces/.+/pods.+", (HttpResponse)new TestHttpResponse().withCode(200).withBody((Object)new TestAsyncBody()));
            return (Pod)((PodResource)((NonNamespaceOperation)c.pods().inNamespace("default")).withName("foo")).get();
        });
        ((AbstractDurationAssert)((ObjectAssert)((AbstractListAssert)((ObjectAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)this.factory.getInstances()).hasSize(2)).element(1)).extracting(TestStandardHttpClient::getRecordedConsumeBytesDirects).asList().hasSize(1)).singleElement()).extracting("request").extracting("timeout").asInstanceOf(InstanceOfAssertFactories.DURATION)).hasSeconds(3L);
        Assertions.assertThat((int)this.client.getConfiguration().getRequestTimeout()).isEqualTo(10000);
    }

    @DisplayName(value="HTTP log retrieval, with no follow, has default timeout")
    @Test
    void httpLogNoFollowOperationsDefaultTimeout() {
        this.informPodReady("foo").expect("/api/v1/namespaces/.+/pods/foo/log", (HttpResponse)new TestHttpResponse().withCode(200).withBody((Object)new TestAsyncBody()));
        ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace("default")).withName("foo")).getLog();
        ((AbstractDurationAssert)((ObjectAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Collection)this.factory.getInstances()).singleElement()).extracting(TestStandardHttpClient::getRecordedConsumeBytesDirects).asList().hasSize(2)).element(1)).extracting("request").extracting("timeout").asInstanceOf(InstanceOfAssertFactories.DURATION)).hasSeconds(10L);
    }

    @DisplayName(value="HTTP log retrieval, with follow, has no timeout")
    @Test
    void httpLogFollowOperationsNoTimeout() {
        this.informPodReady("foo").expect("/api/v1/namespaces/.+/pods/foo/log", (HttpResponse)new TestHttpResponse().withCode(200).withBody((Object)new TestAsyncBody()));
        try (LogWatch ignore = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace("default")).withName("foo")).watchLog();){
            ((ObjectAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Collection)this.factory.getInstances()).singleElement()).extracting(TestStandardHttpClient::getRecordedConsumeBytesDirects).asList().hasSize(2)).element(1)).extracting("request").extracting("timeout").isNull();
        }
    }

    @DisplayName(value="Scale operation has default timeout")
    @Test
    void scaleHasDefaultTimeout() {
        TestStandardHttpClient httpClient = (TestStandardHttpClient)this.factory.getInstances().iterator().next();
        TestStandardHttpClient.FutureProvider future = (r, c) -> {
            TestAsyncBody body = new TestAsyncBody();
            c.consume(Collections.singletonList(ByteBuffer.wrap("{\"spec\":{\"replicas\":0}}".getBytes(StandardCharsets.UTF_8))), (AsyncBody)body);
            return CompletableFuture.completedFuture(new TestHttpResponse().withCode(200).withBody((Object)body));
        };
        IntStream.range(0, 2).forEach(i -> httpClient.expect("/apis/apps/v1/namespaces/.+/deployments/foo/scale", future));
        httpClient.expect("/apis/apps/v1/namespaces/.+/deployments/foo", (HttpResponse)new TestHttpResponse().withCode(200).withBody((Object)new TestAsyncBody()));
        ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace("default")).withName("foo")).scale(1);
        ((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Collection)this.factory.getInstances()).singleElement()).extracting(TestStandardHttpClient::getRecordedConsumeBytesDirects).asList().hasSize(3)).extracting("request.timeout").allMatch(d -> d.equals(Duration.ofSeconds(10L)));
    }

    @DisplayName(value="Delete operations have default timeout")
    @Test
    void deleteHasDefaultTimeout() {
        ((TestStandardHttpClient)this.factory.getInstances().iterator().next()).expect("/api/v1/namespaces/.+/pods/foo", (HttpResponse)new TestHttpResponse().withCode(200).withBody((Object)new TestAsyncBody()));
        ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace("default")).withName("foo")).delete();
        ((AbstractDurationAssert)((ObjectAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Collection)this.factory.getInstances()).singleElement()).extracting(TestStandardHttpClient::getRecordedConsumeBytesDirects).asList().hasSize(1)).singleElement()).extracting("request").extracting("timeout").asInstanceOf(InstanceOfAssertFactories.DURATION)).hasSeconds(10L);
    }

    @DisplayName(value="Upload WS requests have default timeout for upgrade")
    @Test
    void uploadWsUpgradeHasDefaultTimeout() throws Exception {
        WebSocket webSocket = (WebSocket)Mockito.mock(WebSocket.class);
        Mockito.when((Object)webSocket.send((ByteBuffer)ArgumentMatchers.any())).thenReturn((Object)true);
        TestStandardHttpClient.WsFutureProvider future = (s, l) -> {
            l.onOpen(webSocket);
            l.onClose(webSocket, 0, "done");
            return CompletableFuture.completedFuture(new WebSocketResponse(new WebSocketUpgradeResponse(null), webSocket));
        };
        IntStream.range(0, 2).forEach(i -> this.informPodReady("bar").wsExpect("/api/v1/namespaces/.+/pods/bar/exec", future));
        try (ByteArrayInputStream bis = new ByteArrayInputStream("baz".getBytes(StandardCharsets.UTF_8));){
            ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace("default")).withName("bar")).file("/temp/file").upload((InputStream)bis);
        }
        ((ListAssert)((ListAssert)((ObjectAssert)Assertions.assertThat((Collection)this.factory.getInstances()).singleElement()).extracting(TestStandardHttpClient::getRecordedBuildWebSocketDirects).asInstanceOf(InstanceOfAssertFactories.list(TestStandardHttpClient.RecordedBuildWebSocketDirect.class))).hasSize(2)).extracting(r -> r.getStandardWebSocketBuilder().asHttpRequest().getTimeout()).allMatch(d -> d.equals(Duration.ofSeconds(10L)));
    }

    private TestStandardHttpClient informPodReady(String podName) {
        return ((TestStandardHttpClient)this.factory.getInstances().iterator().next()).expect("/api/v1/namespaces/.+/pods", (r, c) -> {
            TestAsyncBody body = new TestAsyncBody();
            c.consume(Collections.singletonList(ByteBuffer.wrap(("{\"metadata\": {},\"items\":[{\"metadata\":{\"name\":\"" + podName + "\"},\"spec\":{\"containers\":[{\"name\":\"" + podName + "\"}]},\"status\":{\"conditions\":[{\"type\":\"Ready\",\"status\":true}]}}]}").getBytes(StandardCharsets.UTF_8))), (AsyncBody)body);
            return CompletableFuture.completedFuture(new TestHttpResponse().withCode(200).withBody((Object)body));
        });
    }
}

