/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.api.model.StatusCause;
import io.fabric8.kubernetes.api.model.StatusFluent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.ExecWebSocketListener;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.http.WebSocket;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;

class ExecWebSocketListenerTest {
    ExecWebSocketListenerTest() {
    }

    @Test
    void testParseExitCodeSuccess() {
        Assert.assertEquals((long)0L, (long)ExecWebSocketListener.parseExitCode((Status)((StatusBuilder)new StatusBuilder().withStatus("Success")).build()));
    }

    @Test
    void testParseExitCodeInvalid() {
        Assert.assertEquals((long)-1L, (long)ExecWebSocketListener.parseExitCode((Status)((StatusBuilder)new StatusBuilder().withStatus("don't know")).build()));
    }

    @Test
    void testParseExitCodeNonZeroInvalid() {
        Assert.assertEquals((long)-1L, (long)ExecWebSocketListener.parseExitCode((Status)((StatusBuilder)((StatusBuilder)new StatusBuilder().withStatus("Failed")).withReason("NonZeroExitCode")).build()));
    }

    @Test
    void testParseExitCodeNonZero() {
        Assert.assertEquals((long)126L, (long)ExecWebSocketListener.parseExitCode((Status)((StatusBuilder)((StatusFluent.DetailsNested)((StatusBuilder)((StatusBuilder)new StatusBuilder().withStatus("Failed")).withReason("NonZeroExitCode")).withNewDetails().withCauses(new StatusCause[]{new StatusCause("ExitCode", "126", "ExitCode")})).endDetails()).build()));
    }

    @Test
    void testSendShouldTruncateAndSendFlaggedWebSocketData() {
        WebSocket mockedWebSocket = (WebSocket)Mockito.mock(WebSocket.class);
        Mockito.when((Object)mockedWebSocket.send((ByteBuffer)Mockito.any())).thenReturn((Object)true);
        ExecWebSocketListener listner = new ExecWebSocketListener(new PodOperationContext());
        listner.onOpen(mockedWebSocket);
        byte[] toSend = new byte[]{1, 3, 3, 7, 0};
        listner.sendWithErrorChecking(toSend, 0, 4);
        ((WebSocket)Mockito.verify((Object)mockedWebSocket, (VerificationMode)VerificationModeFactory.times((int)1))).send(ByteBuffer.wrap(new byte[]{0, 1, 3, 3, 7}));
    }

    @Test
    void testCheckErrorHasErrorFromMessageShouldThrowException() {
        ExecWebSocketListener listener = new ExecWebSocketListener(new PodOperationContext().toBuilder().terminateOnError(true).build());
        listener.onMessage(null, ByteBuffer.wrap(new byte[]{2, 1, 1}));
        Assertions.assertThrows(KubernetesClientException.class, () -> listener.checkError());
    }

    @Test
    void testCheckErrorHasErrorFromFailureShouldThrowException() {
        ExecWebSocketListener listener = new ExecWebSocketListener(new PodOperationContext());
        listener.onError(null, (Throwable)new IOException("here"), true);
        Assertions.assertThrows(KubernetesClientException.class, () -> listener.checkError());
    }

    @Test
    void testGracefulClose() {
        ExecWebSocketListener listener = new ExecWebSocketListener(new PodOperationContext());
        WebSocket mock = (WebSocket)Mockito.mock(WebSocket.class);
        listener.onOpen(mock);
        listener.close();
        Assertions.assertFalse((boolean)listener.exitCode().isDone());
        ((WebSocket)Mockito.verify((Object)mock)).sendClose(Mockito.anyInt(), Mockito.anyString());
    }

    @Test
    void testOnClose() {
        ExecWebSocketListener listener = new ExecWebSocketListener(new PodOperationContext());
        WebSocket mock = (WebSocket)Mockito.mock(WebSocket.class);
        listener.onClose(mock, 1000, "testing");
        Assert.assertNull(listener.exitCode().join());
    }
}

