/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.utils.CommonThreadPool;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class AbstractWatchManagerTest {
    AbstractWatchManagerTest() {
    }

    @Test
    @DisplayName(value="closeEvent, is idempotent, multiple calls only close watcher once")
    void closeEventIsIdempotent() throws MalformedURLException {
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        for (int it = 0; it < 10; ++it) {
            awm.closeEvent();
        }
        Assertions.assertThat((int)watcher.closeCount.get()).isEqualTo(1);
    }

    @Test
    @DisplayName(value="closeEvent, with Exception, is idempotent, multiple calls only close watcher once")
    void closeEventWithExceptionIsIdempotent() throws MalformedURLException {
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        for (int it = 0; it < 10; ++it) {
            awm.close(new WatcherException("Mock"));
        }
        Assertions.assertThat((int)watcher.closeCount.get()).isEqualTo(1);
    }

    @Test
    void closeEventWithExceptionIsIdempotentWithReconnecting() throws MalformedURLException {
        WatcherAdapter<HasMetadata> watcher = new WatcherAdapter<HasMetadata>(){

            public boolean reconnecting() {
                return true;
            }
        };
        WatchManager<HasMetadata> awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        for (int it = 0; it < 10; ++it) {
            awm.close(new WatcherException("Mock"));
        }
        Assertions.assertThat((int)((WatcherAdapter)watcher).closeCount.get()).isEqualTo(1);
    }

    @Test
    @DisplayName(value="closeWebSocket, closes web socket with 1000 code (Normal Closure)")
    void closeWebSocket() {
        WebSocket webSocket = (WebSocket)Mockito.mock(WebSocket.class);
        WatchConnectionManager.closeWebSocket((WebSocket)webSocket);
        ((WebSocket)Mockito.verify((Object)webSocket, (VerificationMode)Mockito.times((int)1))).sendClose(1000, null);
    }

    @Test
    @DisplayName(value="nextReconnectInterval, returns exponential interval values up to the provided limit")
    void nextReconnectInterval() throws MalformedURLException {
        WatchManager awm = new WatchManager(null, (ListOptions)Mockito.mock(ListOptions.class), 0, 10);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(10L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(20L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(40L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(80L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(160L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(320L);
        Assertions.assertThat((long)awm.nextReconnectInterval()).isEqualTo(320L);
    }

    @Test
    @DisplayName(value="cancelReconnect, with null attempt, should do nothing")
    void cancelReconnectNullAttempt() throws MalformedURLException {
        ScheduledFuture sf = (ScheduledFuture)Mockito.spy(ScheduledFuture.class);
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        awm.cancelReconnect();
        ((ScheduledFuture)Mockito.verify((Object)sf, (VerificationMode)Mockito.times((int)0))).cancel(true);
    }

    @Test
    @DisplayName(value="cancelReconnect, with non-null attempt, should cancel")
    void cancelReconnectNonNullAttempt() throws MalformedURLException {
        CompletableFuture cf = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        ExecutorService executor = CommonThreadPool.get();
        MockedStatic utils = Mockito.mockStatic(Utils.class);
        utils.when(() -> Utils.schedule((Executor)((Executor)ArgumentMatchers.any()), (Runnable)((Runnable)ArgumentMatchers.any()), (long)ArgumentMatchers.anyLong(), (TimeUnit)((TimeUnit)((Object)((Object)ArgumentMatchers.any()))))).thenReturn((Object)cf);
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        awm.baseOperation.context = (OperationContext)Mockito.mock(OperationContext.class);
        Mockito.when((Object)awm.baseOperation.context.getExecutor()).thenReturn((Object)executor);
        awm.scheduleReconnect(new AbstractWatchManager.WatchRequestState());
        awm.cancelReconnect();
        ((CompletableFuture)Mockito.verify((Object)cf, (VerificationMode)Mockito.times((int)1))).cancel(true);
    }

    @Test
    void reconnectRace() throws Exception {
        WatcherAdapter watcher = new WatcherAdapter();
        final CompletableFuture done = new CompletableFuture();
        WatchManager<HasMetadata> awm = new WatchManager<HasMetadata>(watcher, (ListOptions)Mockito.mock(ListOptions.class, (Answer)Mockito.RETURNS_DEEP_STUBS), 1, 0){
            boolean first;
            {
                super(watcher, listOptions, reconnectLimit, reconnectInterval);
                this.first = true;
            }

            @Override
            protected void startWatch() {
                if (this.first) {
                    this.first = false;
                    ForkJoinPool.commonPool().execute(() -> this.scheduleReconnect(new AbstractWatchManager.WatchRequestState()));
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new AssertionError((Object)e);
                    }
                } else {
                    done.complete(null);
                }
            }
        };
        awm.cancelReconnect();
        done.get(5L, TimeUnit.SECONDS);
    }

    @Test
    @DisplayName(value="isClosed, after close invocation, should return true")
    void isForceClosedWhenClosed() throws MalformedURLException {
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        awm.close();
        Assertions.assertThat((boolean)awm.isForceClosed()).isTrue();
    }

    @Test
    @DisplayName(value="close, after close invocation, should return true")
    void closeWithNonNullRunnerShouldCancelRunner() throws MalformedURLException {
        WatcherAdapter watcher = new WatcherAdapter();
        WatchManager awm = AbstractWatchManagerTest.withDefaultWatchManager(watcher);
        awm.close();
        Assertions.assertThat((int)awm.closeCount.get()).isEqualTo(1);
    }

    private static <T extends HasMetadata> WatchManager<T> withDefaultWatchManager(Watcher<T> watcher) throws MalformedURLException {
        return new WatchManager<T>(watcher, (ListOptions)Mockito.mock(ListOptions.class, (Answer)Mockito.RETURNS_DEEP_STUBS), 1, 0);
    }

    static BaseOperation mockOperation() {
        BaseOperation operation = (BaseOperation)Mockito.mock(BaseOperation.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)operation.getOperationContext().getExecutor()).thenReturn(Runnable::run);
        return operation;
    }

    private static class WatchManager<T extends HasMetadata>
    extends AbstractWatchManager<T> {
        private final AtomicInteger closeCount = new AtomicInteger(0);

        public WatchManager(Watcher<T> watcher, ListOptions listOptions, int reconnectLimit, int reconnectInterval) throws MalformedURLException {
            super(watcher, AbstractWatchManagerTest.mockOperation(), listOptions, reconnectLimit, reconnectInterval, () -> null);
        }

        protected void start(URL url, Map<String, String> headers, AbstractWatchManager.WatchRequestState state) {
        }

        public void closeCurrentRequest() {
            this.closeCount.addAndGet(1);
        }

        protected void startWatch() {
        }
    }

    private static class WatcherAdapter<T>
    implements Watcher<T> {
        private final AtomicInteger closeCount = new AtomicInteger(0);

        private WatcherAdapter() {
        }

        public void eventReceived(Watcher.Action action, T resource) {
        }

        public void onClose(WatcherException cause) {
            this.closeCount.addAndGet(1);
        }

        public void onClose() {
            this.closeCount.addAndGet(1);
        }
    }
}

