/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.uploadable;

import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.uploadable.PodUpload;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class PodUploadTest {
    private PodOperationsImpl operation;

    PodUploadTest() {
    }

    @BeforeEach
    void setUp() {
        this.operation = (PodOperationsImpl)Mockito.mock(PodOperationsImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    @Test
    @DisplayName(value="With invalid parameters, should throw exception")
    void uploadInvalidParametersShouldThrowException(@TempDir Path pathToUpload) {
        Path nonExistentPath = pathToUpload.resolve("non-existent");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> PodUpload.upload((PodOperationsImpl)this.operation, (Path)nonExistentPath)).withMessage("Provided arguments are not valid (file, directory, path)");
    }

    @Test
    void upload_withFile_shouldUploadFile() throws IOException, InterruptedException {
        Path toUpload = new File(PodUpload.class.getResource("/upload/upload-sample.txt").getFile()).toPath();
        this.uploadFileAndVerify(() -> PodUpload.upload((PodOperationsImpl)this.operation, (Path)toUpload), false, 2560L);
    }

    @Test
    void uploadFileData_whenByteArrayInputStreamProvided_shouldUploadFile() throws IOException, InterruptedException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test data".getBytes());
        this.uploadFileAndVerify(() -> PodUpload.uploadFileData((PodOperationsImpl)this.operation, (InputStream)inputStream), true, 9L);
    }

    @Test
    void upload_withDirectory_shouldUploadDirectory() throws Exception {
        Path toUpload = new File(PodUpload.class.getResource("/upload").getFile()).toPath();
        this.uploadDirectoryAndVerify(() -> PodUpload.upload((PodOperationsImpl)this.operation, (Path)toUpload), 2560L);
    }

    @Test
    void upload_withDirectoryAndLongFileNames_shouldUploadDirectory() throws Exception {
        Path toUpload = new File(PodUpload.class.getResource("/upload_long").getFile()).toPath();
        this.uploadDirectoryAndVerify(() -> PodUpload.upload((PodOperationsImpl)this.operation, (Path)toUpload), 4096L);
    }

    @Test
    void transferTo() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("I'LL BE COPIED".getBytes(Charset.defaultCharset()));
        AtomicReference copiedStream = new AtomicReference();
        InputStreamPumper.Writable consumer = (bytes, offset, length) -> {
            Assertions.assertThat((int)length).isEqualTo(14);
            copiedStream.set(new String(Arrays.copyOf(bytes, 14), Charset.defaultCharset()));
        };
        InputStreamPumper.transferTo((InputStream)input, (InputStreamPumper.Writable)consumer);
        Assertions.assertThat(copiedStream).hasValue((Object)"I'LL BE COPIED");
    }

    @Test
    void createExecCommandForUpload_withFileInRootPath_shouldCreateValidExecCommandForUpload() {
        String result = PodUpload.createExecCommandForUpload((String)"/cp.log");
        Assertions.assertThat((String)result).isEqualTo("mkdir -p '/' && cat - > '/cp.log'");
    }

    @Test
    void createExecCommandForUpload_withNormalFile_shouldCreateValidExecCommandForUpload() {
        String result = PodUpload.createExecCommandForUpload((String)"/tmp/foo/cp.log");
        Assertions.assertThat((String)result).isEqualTo("mkdir -p '/tmp/foo' && cat - > '/tmp/foo/cp.log'");
    }

    @Test
    void createExecCommandForUpload_withSingleQuoteInPath() {
        String result = PodUpload.createExecCommandForUpload((String)"/tmp/fo'o/cp.log");
        Assertions.assertThat((String)result).isEqualTo("mkdir -p '/tmp/fo'\\''o' && cat - > '/tmp/fo'\\''o/cp.log'");
    }

    @Test
    void createExecCommandForUpload_withMultipleSingleQuotesInPath() {
        String result = PodUpload.createExecCommandForUpload((String)"/tmp/f'o'o/c'p.log");
        Assertions.assertThat((String)result).isEqualTo("mkdir -p '/tmp/f'\\''o'\\''o' && cat - > '/tmp/f'\\''o'\\''o/c'\\''p.log'");
    }

    void uploadFileAndVerify(PodUploadTester<Boolean> fileUploadMethodToTest, boolean stream, final long size) throws IOException, InterruptedException {
        Mockito.when((Object)this.operation.getContext().getFile()).thenReturn((Object)"/mock/file");
        if (!stream) {
            this.verifyTar(fileUploadMethodToTest, size, "/mock");
            return;
        }
        Mockito.when((Object)this.operation.writingOutput((OutputStream)Mockito.any())).then((Answer)new Answer<TtyExecErrorable>(){

            public TtyExecErrorable answer(InvocationOnMock invocation) throws Throwable {
                OutputStream out = (OutputStream)invocation.getArgument(0);
                out.write((size + "\n").getBytes(StandardCharsets.UTF_8));
                return PodUploadTest.this.operation;
            }
        });
        boolean result = fileUploadMethodToTest.apply();
        Assertions.assertThat((boolean)result).isTrue();
        ArgumentCaptor captorUpload = ArgumentCaptor.forClass(String[].class);
        ((PodOperationsImpl)Mockito.verify((Object)this.operation.redirectingInput().terminateOnError(), (VerificationMode)Mockito.times((int)1))).exec((String[])captorUpload.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"mkdir -p '/mock' && cat - > '/mock/file'", (Object)((String[])captorUpload.getValue())[2]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(String[].class);
        ((PodOperationsImpl)Mockito.verify((Object)this.operation, (VerificationMode)Mockito.times((int)1))).exec((String[])captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"wc -c < '/mock/file'", (Object)((String[])captor.getValue())[2]);
    }

    private void uploadDirectoryAndVerify(PodUploadTester<Boolean> directoryUpload, long size) throws IOException, InterruptedException {
        Mockito.when((Object)this.operation.getContext().getDir()).thenReturn((Object)"/mock/dir");
        this.verifyTar(directoryUpload, size, "/mock/dir");
    }

    private void verifyTar(PodUploadTester<Boolean> directoryUpload, final long size, String dir) throws IOException, InterruptedException {
        Mockito.when((Object)this.operation.writingOutput((OutputStream)Mockito.any())).then((Answer)new Answer<TtyExecErrorable>(){

            public TtyExecErrorable answer(InvocationOnMock invocation) throws Throwable {
                OutputStream out = (OutputStream)invocation.getArgument(0);
                out.write((size + "\n").getBytes(StandardCharsets.UTF_8));
                return PodUploadTest.this.operation;
            }
        });
        boolean result = directoryUpload.apply();
        Assertions.assertThat((boolean)result).isTrue();
        ArgumentCaptor captorUpload = ArgumentCaptor.forClass(String[].class);
        ((PodOperationsImpl)Mockito.verify((Object)this.operation.redirectingInput().terminateOnError(), (VerificationMode)Mockito.times((int)1))).exec((String[])captorUpload.capture());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((String[])captorUpload.getValue())[2].startsWith("mkdir -p '/tmp' && cat - > '/tmp/fabric8-"));
        ArgumentCaptor captorCount = ArgumentCaptor.forClass(String[].class);
        ((PodOperationsImpl)Mockito.verify((Object)this.operation, (VerificationMode)Mockito.times((int)1))).exec((String[])captorCount.capture());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((String[])captorCount.getValue())[2].startsWith("wc -c < '/tmp/fabric8-"));
        ArgumentCaptor captorExtract = ArgumentCaptor.forClass(String[].class);
        ((PodOperationsImpl)Mockito.verify((Object)this.operation.redirectingInput())).exec((String[])captorExtract.capture());
        String extractCommand = ((String[])captorExtract.getValue())[2];
        org.junit.jupiter.api.Assertions.assertTrue((boolean)extractCommand.startsWith(String.format("mkdir -p '%1$s'; tar -C '%1$s' -xmf /tmp/fabric8-", dir)), (String)extractCommand);
    }

    @FunctionalInterface
    public static interface PodUploadTester<R> {
        public R apply() throws IOException, InterruptedException;
    }
}

