/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.internal;

import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.utils.internal.PodOperationUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class PodOperationUtilTest {
    private PodOperationsImpl podOperations;
    private OperationContext operationContext;

    PodOperationUtilTest() {
    }

    @BeforeEach
    void setUp() {
        this.podOperations = (PodOperationsImpl)Mockito.mock(PodOperationsImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.operationContext = (OperationContext)Mockito.mock(OperationContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    @Test
    void testGetFilteredPodsForLogs() {
        String controllerUid = "controller-uid-ejofjeofer";
        PodList podList = this.getMockPodList(controllerUid);
        List podResourceList = PodOperationUtil.getFilteredPodsForLogs((PodOperationsImpl)this.podOperations, (PodList)podList, (String)controllerUid);
        Assertions.assertNotNull((Object)podResourceList);
        Assertions.assertEquals((int)1, (int)podResourceList.size());
        ((PodOperationsImpl)Mockito.verify((Object)this.podOperations, (VerificationMode)Mockito.times((int)1))).withName((String)ArgumentMatchers.any());
    }

    @Test
    void testGetGenericPodOperations() {
        PodOperationsImpl podOperations = PodOperationUtil.getGenericPodOperations((OperationContext)this.operationContext, (PodOperationContext)new PodOperationContext().withPrettyOutput(false).withReadyWaitTimeout(Integer.valueOf(5)).withContainerId("container1"));
        AssertionsForClassTypes.assertThat((Object)podOperations).isNotNull();
        AssertionsForClassTypes.assertThat((String)podOperations.getName()).isNull();
        AssertionsForClassTypes.assertThat((String)podOperations.getContext().getContainerId()).isEqualTo("container1");
    }

    @Test
    void testWaitUntilReadyBeforeFetchingLogs() {
        PodOperationUtil.waitUntilReadyOrSucceded((PodResource)this.podOperations, (Integer)5);
        ((PodOperationsImpl)Mockito.verify((Object)this.podOperations, (VerificationMode)Mockito.times((int)1))).waitUntilCondition((Predicate)ArgumentMatchers.any(), ArgumentMatchers.eq((long)5L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.SECONDS))));
    }

    @Test
    void testGetPodOperationsForController() {
        String controllerUid = "some-uid";
        Map<String, String> selectorLabels = Collections.singletonMap("foo", "bar");
        FilterWatchListDeletable<Pod, PodList, PodResource> filterWatchListDeletable = this.getMockPodFilterOperation(controllerUid);
        Mockito.when((Object)this.podOperations.withLabels((Map)ArgumentMatchers.any())).thenReturn(filterWatchListDeletable);
        List podResources = PodOperationUtil.getPodOperationsForController((PodOperationsImpl)this.podOperations, (String)controllerUid, selectorLabels);
        Assertions.assertNotNull((Object)podResources);
        Assertions.assertEquals((int)1, (int)podResources.size());
    }

    @Test
    void testWatchLogSinglePod() {
        PodResource podResource = (PodResource)Mockito.mock(PodResource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)Mockito.mock(ByteArrayOutputStream.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        LogWatch logWatch = PodOperationUtil.watchLog(this.createMockPodResourceList(podResource), (OutputStream)byteArrayOutputStream);
        AssertionsForClassTypes.assertThat((Object)logWatch).isNotNull();
        ((PodResource)Mockito.verify((Object)podResource, (VerificationMode)Mockito.times((int)1))).watchLog((OutputStream)byteArrayOutputStream);
    }

    @Test
    void testWatchLogMultiplePodReplicasPicksFirstPod() {
        PodResource p1 = (PodResource)Mockito.mock(PodResource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        PodResource p2 = (PodResource)Mockito.mock(PodResource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)Mockito.mock(ByteArrayOutputStream.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        LogWatch logWatch = PodOperationUtil.watchLog(this.createMockPodResourceList(p1, p2), (OutputStream)byteArrayOutputStream);
        AssertionsForClassTypes.assertThat((Object)logWatch).isNotNull();
        ((PodResource)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).watchLog((OutputStream)byteArrayOutputStream);
        ((PodResource)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)0))).watchLog((OutputStream)byteArrayOutputStream);
    }

    @Test
    void testWatchLogEmptyPodResourceList() {
        AssertionsForClassTypes.assertThat((Object)PodOperationUtil.watchLog(Collections.emptyList(), null)).isNull();
    }

    @Test
    void testGetLogReaderEmptyPodResourceList() {
        AssertionsForClassTypes.assertThat((Object)PodOperationUtil.getLogReader(Collections.emptyList())).isNull();
    }

    @Test
    void testGetLogReaderMultiplePodReplicasPicksFirstPod() {
        PodResource p1 = (PodResource)Mockito.mock(PodResource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        PodResource p2 = (PodResource)Mockito.mock(PodResource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Reader reader = PodOperationUtil.getLogReader(this.createMockPodResourceList(p1, p2));
        AssertionsForClassTypes.assertThat((Object)reader).isNotNull();
        ((PodResource)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).getLogReader();
        ((PodResource)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)0))).getLogReader();
    }

    @Test
    void testGetLogInputStreamEmptyPodResourceList() {
        AssertionsForClassTypes.assertThat((InputStream)PodOperationUtil.getLogInputStream(Collections.emptyList())).isNull();
    }

    @Test
    void testGetLogInputStreamMultiplePodReplicasPicksFirstPod() {
        PodResource p1 = (PodResource)Mockito.mock(PodResource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        PodResource p2 = (PodResource)Mockito.mock(PodResource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        InputStream inputStream = PodOperationUtil.getLogInputStream(this.createMockPodResourceList(p1, p2));
        AssertionsForClassTypes.assertThat((InputStream)inputStream).isNotNull();
        ((PodResource)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).getLogInputStream();
        ((PodResource)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)0))).getLogInputStream();
    }

    @Test
    void testGetLog() {
        PodResource p1 = (PodResource)Mockito.mock(PodResource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        PodResource p2 = (PodResource)Mockito.mock(PodResource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)p1.getLog(ArgumentMatchers.anyBoolean())).thenReturn((Object)"p1-log");
        Mockito.when((Object)p2.getLog(ArgumentMatchers.anyBoolean())).thenReturn((Object)"p2-log");
        String result = PodOperationUtil.getLog(this.createMockPodResourceList(p1, p2), (Boolean)false);
        ((AbstractStringAssert)AssertionsForClassTypes.assertThat((String)result).isNotNull()).isEqualTo("p1-logp2-log");
        ((PodResource)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).getLog(false);
        ((PodResource)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).getLog(false);
    }

    private PodList getMockPodList(String controllerUid) {
        return ((PodListBuilder)((PodListBuilder)new PodListBuilder().addToItems(new Pod[]{((PodBuilder)((PodFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)((ObjectMetaFluent.OwnerReferencesNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).addNewOwnerReference().withController(Boolean.valueOf(true))).withUid(controllerUid)).endOwnerReference()).endMetadata()).build()})).addToItems(new Pod[]{((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod2")).endMetadata()).build()})).build();
    }

    private FilterWatchListDeletable<Pod, PodList, PodResource> getMockPodFilterOperation(final String controllerUid) {
        FilterWatchListDeletable result = (FilterWatchListDeletable)Mockito.mock(FilterWatchListDeletable.class);
        Mockito.when((Object)result.list()).then((Answer)new Answer<PodList>(){

            public PodList answer(InvocationOnMock invocation) throws Throwable {
                return PodOperationUtilTest.this.getMockPodList(controllerUid);
            }
        });
        return result;
    }

    @SafeVarargs
    private final List<PodResource> createMockPodResourceList(PodResource ... podResources) {
        ArrayList<PodResource> podResourceList = new ArrayList<PodResource>();
        Collections.addAll(podResourceList, podResources);
        return podResourceList;
    }
}

