/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.internal.CreateOrReplaceHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class CreateOrReplaceHelperTest {
    CreateOrReplaceHelperTest() {
    }

    @Test
    void testCreateOrReplaceShouldCreate() {
        AtomicBoolean wasPodCreated = new AtomicBoolean(false);
        UnaryOperator createPodTask = p -> {
            wasPodCreated.set(true);
            return this.getPod();
        };
        CreateOrReplaceHelper podCreateOrReplaceHelper = new CreateOrReplaceHelper(createPodTask, p -> this.getPod(), p -> this.getPod(), p -> this.getPod());
        Pod p2 = this.getPod();
        p2.getMetadata().setResourceVersion("1");
        Pod podCreated = (Pod)podCreateOrReplaceHelper.createOrReplace((HasMetadata)p2);
        Assertions.assertNotNull((Object)podCreated);
        Assertions.assertTrue((boolean)wasPodCreated.get());
        Assert.assertEquals((Object)"1", (Object)p2.getMetadata().getResourceVersion());
    }

    @Test
    void testCreateOrReplaceShouldReplace() {
        AtomicBoolean wasPodReplaced = new AtomicBoolean(false);
        UnaryOperator createPodTask = p -> {
            throw new KubernetesClientException("Already exist", 409, ((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(409))).build());
        };
        UnaryOperator replacePodTask = p -> {
            wasPodReplaced.set(true);
            return this.getPod();
        };
        CreateOrReplaceHelper podCreateOrReplaceHelper = new CreateOrReplaceHelper(createPodTask, replacePodTask, p -> this.getPod(), p -> this.getPod());
        Pod podCreated = (Pod)podCreateOrReplaceHelper.createOrReplace((HasMetadata)this.getPod());
        Assertions.assertNotNull((Object)podCreated);
        Assertions.assertTrue((boolean)wasPodReplaced.get());
    }

    @Test
    void testCreateOrReplaceShouldRetryOnInternalServerError() {
        AtomicBoolean waitedForPod = new AtomicBoolean(false);
        UnaryOperator createPodTask = (UnaryOperator)Mockito.mock(UnaryOperator.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        UnaryOperator reloadTask = (UnaryOperator)Mockito.mock(UnaryOperator.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when(reloadTask.apply(ArgumentMatchers.any())).thenReturn(null);
        Mockito.when(createPodTask.apply(ArgumentMatchers.any())).thenThrow(new Throwable[]{new KubernetesClientException("The POST operation could not be completed at this time, please try again", 500, ((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(500))).build())}).thenReturn((Object)this.getPod());
        UnaryOperator waitTask = p -> {
            waitedForPod.set(true);
            return this.getPod();
        };
        CreateOrReplaceHelper podCreateOrReplaceHelper = new CreateOrReplaceHelper(createPodTask, p -> this.getPod(), waitTask, reloadTask);
        Pod podCreated = (Pod)podCreateOrReplaceHelper.createOrReplace((HasMetadata)this.getPod());
        Assertions.assertNotNull((Object)podCreated);
        Assertions.assertTrue((boolean)waitedForPod.get());
    }

    @Test
    void testCreateOrReplaceThrowExceptionOnErrorCodeLessThan500() {
        UnaryOperator createPodTask = p -> {
            throw new KubernetesClientException("The POST operation could not be completed at this time, please try again", 400, ((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(400))).build());
        };
        CreateOrReplaceHelper podCreateOrReplaceHelper = new CreateOrReplaceHelper(createPodTask, p -> this.getPod(), p -> this.getPod(), p -> this.getPod());
        Pod podToCreate = this.getPod();
        Assertions.assertThrows(KubernetesClientException.class, () -> {
            Pod cfr_ignored_0 = (Pod)podCreateOrReplaceHelper.createOrReplace((HasMetadata)podToCreate);
        });
    }

    private Pod getPod() {
        return ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("p1")).endMetadata()).build();
    }
}

