/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OkHttpClientFactoryTest {
    OkHttpClientFactoryTest() {
    }

    @Test
    void shouldNotRespectMaxRequests() {
        OkHttpClientImpl client = new OkHttpClientFactory().newBuilder(new ConfigBuilder().build()).build();
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)client.getOkHttpClient().dispatcher().getMaxRequests());
        Config config = ((ConfigBuilder)new ConfigBuilder().withMaxConcurrentRequests(120)).build();
        client = new OkHttpClientFactory().newBuilder(config).build();
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)client.getOkHttpClient().dispatcher().getMaxRequests());
    }

    @Test
    void shouldNotRespectMaxRequestsPerHost() {
        OkHttpClientImpl client = new OkHttpClientFactory().newBuilder(new ConfigBuilder().build()).build();
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)client.getOkHttpClient().dispatcher().getMaxRequestsPerHost());
        Config config = ((ConfigBuilder)new ConfigBuilder().withMaxConcurrentRequestsPerHost(20)).build();
        client = new OkHttpClientFactory().newBuilder(config).build();
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)client.getOkHttpClient().dispatcher().getMaxRequestsPerHost());
    }
}

