/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class OperationContextTest {
    private Client client;

    OperationContextTest() {
    }

    @BeforeEach
    public void setUp() {
        this.client = (Client)Mockito.mock(Client.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    @Test
    void testNamespaceIsSetFromOperationContext() {
        OperationContext operationContext = new OperationContext();
        Mockito.when((Object)this.client.getConfiguration().getNamespace()).thenReturn((Object)"namespace-from-config");
        operationContext = operationContext.withNamespace("operation-namespace").withClient(this.client);
        Assertions.assertNotNull((Object)operationContext);
        Assertions.assertEquals((Object)"operation-namespace", (Object)operationContext.getNamespace());
    }

    @Test
    void testCompleteOperationContext() {
        OperationContext operationContext = new OperationContext();
        operationContext = operationContext.withNamespace("operation-namespace").withName("operand-name").withClient(this.client).withApiGroupName("batch").withApiGroupVersion("v1").withPlural("jobs").withItem((Object)((JobBuilder)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName("testItem")).endMetadata()).build()).withLabels(Collections.singletonMap("test", "labels")).withLabelsIn(Collections.singletonMap("test", new String[]{"labelsIn1", "labelsIn2"})).withLabelsNot(Collections.singletonMap("test", new String[]{"labelsNot"})).withLabelsNotIn(Collections.singletonMap("test", new String[]{"labelsNotIn"})).withFields(Collections.singletonMap("test", "field")).withFieldsNot(Collections.singletonMap("test", new String[]{"fieldsNot"})).withResourceVersion("234343").withGracePeriodSeconds(0L).withPropagationPolicy(DeletionPropagation.BACKGROUND);
        Assertions.assertNotNull((Object)operationContext);
        Assertions.assertEquals((Object)"operation-namespace", (Object)operationContext.getNamespace());
        Assertions.assertEquals((Object)"operand-name", (Object)operationContext.getName());
        Assertions.assertEquals((Object)"batch", (Object)operationContext.getApiGroupName());
        Assertions.assertEquals((Object)"v1", (Object)operationContext.getApiGroupVersion());
        Assertions.assertEquals((Object)"jobs", (Object)operationContext.getPlural());
        Assertions.assertNotNull((Object)operationContext.getItem());
        Assertions.assertTrue((boolean)(operationContext.getItem() instanceof Job));
        Assertions.assertEquals((Object)"labels", operationContext.getLabels().get("test"));
        Assertions.assertArrayEquals((Object[])new String[]{"labelsIn1", "labelsIn2"}, (Object[])((Object[])operationContext.getLabelsIn().get("test")));
        Assertions.assertArrayEquals((Object[])new String[]{"labelsNot"}, (Object[])((Object[])operationContext.getLabelsNot().get("test")));
        Assertions.assertArrayEquals((Object[])new String[]{"labelsNotIn"}, (Object[])((Object[])operationContext.getLabelsNotIn().get("test")));
        Assertions.assertEquals((Object)"field", operationContext.getFields().get("test"));
        Assertions.assertArrayEquals((Object[])new String[]{"fieldsNot"}, (Object[])((Object[])operationContext.getFieldsNot().get("test")));
        Assertions.assertEquals((Object)"234343", (Object)operationContext.getResourceVersion());
        Assertions.assertEquals((long)0L, (long)operationContext.getGracePeriodSeconds());
        Assertions.assertEquals((Object)DeletionPropagation.BACKGROUND, (Object)operationContext.getPropagationPolicy());
        Assertions.assertEquals((Object)"test=labels,test!=labelsNot,test in (labelsIn1,labelsIn2),test notin (labelsNotIn)", (Object)operationContext.getLabelQueryParam());
        Assertions.assertEquals((Object)"metadata.name=operand-name,test=field,test!=fieldsNot", (Object)operationContext.getFieldQueryParam());
        String selectorAsString = "foo=bar,!baz";
        operationContext = operationContext.withLabelSelector("foo=bar,!baz");
        Assertions.assertEquals((Object)"foo=bar,!baz", (Object)operationContext.getLabelQueryParam());
        Assertions.assertEquals((Object)"metadata.name=operand-name,test=field,test!=fieldsNot", (Object)operationContext.getFieldQueryParam());
    }
}

