/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.dsl.internal.ExecWatchInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExecWatchInputStreamTest {
    @Test
    void testExceptionalExit() throws IOException {
        AtomicInteger count = new AtomicInteger();
        ExecWatchInputStream is = new ExecWatchInputStream(() -> count.getAndIncrement());
        is.onExit(null, (Throwable)new Exception());
        Assertions.assertThrows(IOException.class, () -> is.read());
        Assertions.assertEquals((int)0, (int)count.get());
    }

    @Test
    void testNormalExit() throws IOException {
        AtomicInteger count = new AtomicInteger();
        ExecWatchInputStream is = new ExecWatchInputStream(() -> count.getAndIncrement());
        is.onExit(Integer.valueOf(1), null);
        Assertions.assertEquals((int)-1, (int)is.read());
        Assertions.assertEquals((int)0, (int)count.get());
    }

    @Test
    void testConsumerAfterClose() throws IOException {
        AtomicInteger count = new AtomicInteger();
        ExecWatchInputStream is = new ExecWatchInputStream(() -> count.getAndIncrement());
        is.close();
        Assertions.assertEquals((int)0, (int)count.get());
        is.consume(Collections.singletonList(ByteBuffer.allocate(1)));
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void testConsume() throws IOException {
        AtomicInteger count = new AtomicInteger();
        ExecWatchInputStream is = new ExecWatchInputStream(() -> count.getAndIncrement());
        is.consume(Collections.singletonList(ByteBuffer.allocate(1)));
        Assertions.assertEquals((int)0, (int)is.read());
        Assertions.assertEquals((int)0, (int)count.get());
        CompletableFuture<Void> readFuture = CompletableFuture.runAsync(() -> {
            try {
                is.read();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        });
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> count.get() == 1);
        is.consume(Collections.singletonList(ByteBuffer.allocate(1)));
        readFuture.join();
    }
}

