/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodOperationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PodOperationUtil.class);

    private PodOperationUtil() {
    }

    public static List<PodResource> getFilteredPodsForLogs(PodOperationsImpl podOperations, PodList controllerPodList, String controllerUid) {
        ArrayList<PodResource> pods = new ArrayList<PodResource>();
        for (Pod pod : controllerPodList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid((HasMetadata)pod);
            if (ownerReference == null || !ownerReference.getUid().equals(controllerUid)) continue;
            pods.add((PodResource)podOperations.withName(pod.getMetadata().getName()));
        }
        return pods;
    }

    public static PodOperationsImpl getGenericPodOperations(OperationContext context, PodOperationContext podOperationContext) {
        return new PodOperationsImpl(podOperationContext, context.withName(null).withApiGroupName(null).withApiGroupVersion("v1"));
    }

    public static List<PodResource> getPodOperationsForController(OperationContext context, PodOperationContext podOperationContext, String controllerUid, Map<String, String> selectorLabels) {
        return PodOperationUtil.getPodOperationsForController(PodOperationUtil.getGenericPodOperations(context, podOperationContext), controllerUid, selectorLabels);
    }

    public static LogWatch watchLog(List<PodResource> podResources, OutputStream out) {
        return PodOperationUtil.findFirstPodResource(podResources).map(it -> it.watchLog(out)).orElse(null);
    }

    public static Reader getLogReader(List<PodResource> podResources) {
        return PodOperationUtil.findFirstPodResource(podResources).map(Loggable::getLogReader).orElse(null);
    }

    public static InputStream getLogInputStream(List<PodResource> podResources) {
        return PodOperationUtil.findFirstPodResource(podResources).map(Loggable::getLogInputStream).orElse(null);
    }

    private static Optional<PodResource> findFirstPodResource(List<PodResource> podResources) {
        if (!podResources.isEmpty()) {
            if (podResources.size() > 1) {
                LOG.debug("Found {} pods, Using first one to get log", (Object)podResources.size());
            }
            return Optional.ofNullable(podResources.get(0));
        }
        return Optional.empty();
    }

    public static String getLog(List<PodResource> podOperationList, Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PodResource podOperation : podOperationList) {
            stringBuilder.append(podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    public static List<PodResource> getPodOperationsForController(PodOperationsImpl podOperations, String controllerUid, Map<String, String> selectorLabels) {
        PodList controllerPodList = (PodList)podOperations.withLabels((Map)selectorLabels).list();
        return PodOperationUtil.getFilteredPodsForLogs(podOperations, controllerPodList, controllerUid);
    }

    public static Pod waitUntilReadyOrSucceded(PodResource podOperation, Integer logWaitTimeout) {
        AtomicReference podRef = new AtomicReference();
        try {
            podOperation.waitUntilCondition(p -> {
                podRef.set(p);
                return p != null && (Readiness.isPodReady(p) || Readiness.isPodSucceeded(p));
            }, logWaitTimeout.intValue(), TimeUnit.SECONDS);
        }
        catch (Exception otherException) {
            LOG.debug("Error while waiting for Pod to become Ready: {}", (Object)otherException.getMessage());
        }
        return (Pod)podRef.get();
    }
}

