/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.DeletableWithOptions;
import io.fabric8.kubernetes.client.dsl.FieldValidateable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerWritable;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NamespaceableResource;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Waitable;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl
implements ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata>,
Waitable<List<HasMetadata>, HasMetadata> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.class);
    protected static final String EXPRESSION = "expression";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private OperationContext context;

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OperationContext context) {
        this.context = context;
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(Client client, Object item) {
        this(HasMetadataOperationsImpl.defaultContext(client).withItem(item));
    }

    @Override
    public List<HasMetadata> waitUntilReady(long amount, TimeUnit timeUnit) {
        return this.waitUntilCondition(resource -> Objects.nonNull(resource) && this.getReadiness().isReady((HasMetadata)resource), amount, timeUnit);
    }

    List<HasMetadata> getItems() {
        Object item = this.context.getItem();
        return this.asHasMetadata(item).stream().map(meta -> NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(meta, Collections.emptyList(), this.context)).collect(Collectors.toList());
    }

    @Override
    public List<HasMetadata> items() {
        return this.getItems();
    }

    @Override
    public Stream<NamespaceableResource<HasMetadata>> resources() {
        return this.getItems().stream().map(this::getResource);
    }

    public List<NamespaceableResource<HasMetadata>> getResources() {
        return this.resources().collect(Collectors.toList());
    }

    NamespaceableResource<HasMetadata> getResource(HasMetadata meta) {
        return this.context.clientInWriteContext(KubernetesClient.class).resource(meta);
    }

    @Override
    public List<HasMetadata> waitUntilCondition(Predicate<HasMetadata> condition, long amount, TimeUnit timeUnit) {
        List<NamespaceableResource<HasMetadata>> operations = this.getResources();
        if (operations.isEmpty()) {
            return Collections.emptyList();
        }
        List items = operations.stream().map(Resource::item).collect(Collectors.toList());
        ArrayList futures = new ArrayList(items.size());
        for (Resource resource : operations) {
            CompletableFuture futureCondition = resource.informOnCondition(l -> {
                if (l.isEmpty()) {
                    return condition.test(null);
                }
                return condition.test((HasMetadata)l.get(0));
            });
            futures.add(futureCondition);
        }
        ArrayList<HasMetadata> results = new ArrayList<HasMetadata>();
        ArrayList<HasMetadata> arrayList = new ArrayList<HasMetadata>();
        long finish = System.nanoTime() + timeUnit.toNanos(amount);
        for (int i = 0; i < items.size(); ++i) {
            HasMetadata meta = (HasMetadata)items.get(i);
            CompletableFuture future = (CompletableFuture)futures.get(i);
            try {
                results.add((HasMetadata)((CompletableFuture)future.thenApply(l -> l.isEmpty() ? null : (HasMetadata)l.get(0))).get(Math.max(0L, finish - System.nanoTime()), TimeUnit.NANOSECONDS));
                continue;
            }
            catch (TimeoutException e) {
                arrayList.add(meta);
                NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.logAsNotReady(e, meta);
                continue;
            }
            catch (ExecutionException e) {
                arrayList.add(meta);
                NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.logAsNotReady(e.getCause(), meta);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw KubernetesClientException.launderThrowable(e);
            }
            finally {
                future.cancel(true);
            }
        }
        if (!arrayList.isEmpty()) {
            throw new KubernetesClientTimeoutException(arrayList, amount, timeUnit);
        }
        return results;
    }

    private static void logAsNotReady(Throwable t, HasMetadata meta) {
        LOGGER.warn("Error while waiting for: [{}] with name: [{}] in namespace: [{}]: {}. The resource will be considered not ready.", new Object[]{meta.getKind(), meta.getMetadata().getName(), meta.getMetadata().getNamespace(), t.getMessage()});
        LOGGER.debug("The error stack trace:", t);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> withParameters(Map<String, String> parameters) {
        Object item = Serialization.unmarshal((InputStream)this.context.getItem(), parameters);
        return this.newInstance(this.context.withItem(item));
    }

    @Override
    public ListVisitFromServerWritable<HasMetadata> dryRun(boolean isDryRun) {
        return this.newInstance(this.context.withDryRun(isDryRun));
    }

    @Override
    public ListVisitFromServerWritable<HasMetadata> fieldValidation(FieldValidateable.Validation fieldValidation) {
        return this.newInstance(this.context.withFieldValidation(fieldValidation));
    }

    @Override
    public List<HasMetadata> createOrReplace() {
        List<NamespaceableResource<HasMetadata>> operations = this.getResources();
        return operations.stream().map(CreateOrReplaceable::createOrReplace).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<StatusDetails> delete() {
        List<StatusDetails> deleted = this.resources().flatMap(r -> r.delete().stream()).collect(Collectors.toList());
        BaseOperation.waitForDelete(deleted, this.context, this);
        return deleted;
    }

    @Override
    public List<HasMetadata> get() {
        return this.performOperation(Gettable::get);
    }

    @Override
    public ListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> inNamespace(String explicitNamespace) {
        if (explicitNamespace == null) {
            throw new KubernetesClientException("namespace cannot be null");
        }
        return this.newInstance(this.context.withNamespace(explicitNamespace));
    }

    @Override
    public Gettable<List<HasMetadata>> fromServer() {
        return this;
    }

    public ListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> accept(Visitor ... visitors) {
        return this.newInstance(this.context.withItem(this.getItems().stream().map(i -> NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(i, Arrays.asList(visitors), this.context)).collect(Collectors.toList())));
    }

    @Override
    public ListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> withGracePeriod(long gracePeriodSeconds) {
        return this.newInstance(this.context.withGracePeriodSeconds(gracePeriodSeconds));
    }

    @Override
    public ListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return this.newInstance(this.context.withPropagationPolicy(propagationPolicy));
    }

    protected Readiness getReadiness() {
        return Readiness.getInstance();
    }

    protected List<HasMetadata> asHasMetadata(Object item) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        if (item instanceof KubernetesResourceList) {
            result.addAll(((KubernetesResourceList)item).getItems());
        } else if (item instanceof HasMetadata) {
            result.add((HasMetadata)item);
        } else if (item instanceof Collection) {
            for (Object o : (Collection)item) {
                if (o == null) continue;
                result.add((HasMetadata)o);
            }
        } else if (item != null) {
            throw new IllegalArgumentException("Could not convert item to a list of HasMetadata");
        }
        return result;
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl newInstance(OperationContext context) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(context);
    }

    static HasMetadata acceptVisitors(HasMetadata item, List<Visitor> visitors, OperationContext context) {
        if (!visitors.isEmpty()) {
            Object builder = context.getHandler(item).edit(item);
            for (Visitor v : visitors) {
                builder.accept(new Visitor[]{v});
            }
            item = (HasMetadata)builder.build();
        }
        return item;
    }

    @Override
    public List<HasMetadata> create() {
        return this.performOperation(CreateOrReplaceable::create);
    }

    @Override
    public ListVisitFromServerWritable<HasMetadata> dryRun() {
        return this.dryRun(true);
    }

    @Override
    public ListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> inAnyNamespace() {
        return this.newInstance(this.context.withNamespace(null));
    }

    @Override
    public List<HasMetadata> replace() {
        return this.performOperation(Replaceable::replace);
    }

    private List<HasMetadata> performOperation(Function<? super NamespaceableResource<HasMetadata>, ? extends HasMetadata> operation) {
        return this.getResources().stream().map(operation).collect(Collectors.toList());
    }

    @Override
    public List<HasMetadata> replaceStatus() {
        return this.performOperation(Replaceable::replaceStatus);
    }

    @Override
    public DeletableWithOptions withTimeout(long timeout, TimeUnit unit) {
        return this.newInstance(this.context.withTimeout(timeout, unit));
    }

    @Override
    public DeletableWithOptions withTimeoutInMillis(long timeoutInMillis) {
        return this.withTimeout(timeoutInMillis, TimeUnit.MILLISECONDS);
    }
}

