/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.uploadable;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.internal.ExecWebSocketListener;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.uploadable.PodUpload;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.impl.BaseClient;
import io.fabric8.kubernetes.client.utils.CommonThreadPool;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class PodUploadTest {
    private HttpClient mockClient;
    private WebSocket mockWebSocket;
    private PodOperationsImpl operation;

    PodUploadTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.mockWebSocket = (WebSocket)Mockito.mock(WebSocket.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.mockWebSocket.send((ByteBuffer)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.mockClient.newBuilder().readTimeout(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class))).build()).thenReturn((Object)this.mockClient);
        BaseClient client = (BaseClient)Mockito.mock(BaseClient.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)((BaseClient)client.adapt(BaseClient.class)).getExecutor()).thenReturn((Object)CommonThreadPool.get());
        Config config = (Config)Mockito.mock(Config.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)config.getMasterUrl()).thenReturn((Object)"https://openshift.com:8443");
        Mockito.when((Object)config.getNamespace()).thenReturn((Object)"default");
        Mockito.when((Object)client.getConfiguration()).thenReturn((Object)config);
        Mockito.when((Object)client.getHttpClient()).thenReturn((Object)this.mockClient);
        Pod item = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod")).endMetadata()).withNewSpec().addNewContainer().withName("container")).endContainer()).endSpec()).build();
        this.operation = new PodOperationsImpl(new PodOperationContext(), new OperationContext().withItem((Object)item).withClient((Client)client));
    }

    @Test
    @DisplayName(value="With invalid parameters, should throw exception")
    void uploadInvalidParametersShouldThrowException(@TempDir Path pathToUpload) {
        Path nonExistentPath = pathToUpload.resolve("non-existent");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> PodUpload.upload((PodOperationsImpl)this.operation, (Path)nonExistentPath)).withMessage("Provided arguments are not valid (file, directory, path)");
    }

    @Test
    void upload_withFile_shouldUploadFile() throws IOException, InterruptedException {
        Path toUpload = new File(PodUpload.class.getResource("/upload/upload-sample.txt").getFile()).toPath();
        this.uploadFileAndVerify(() -> PodUpload.upload((PodOperationsImpl)this.operation, (Path)toUpload));
    }

    @Test
    void uploadFileData_whenByteArrayInputStreamProvided_shouldUploadFile() throws IOException, InterruptedException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test data".getBytes());
        this.uploadFileAndVerify(() -> PodUpload.uploadFileData((PodOperationsImpl)this.operation, (InputStream)inputStream));
    }

    @Test
    void upload_withDirectory_shouldUploadDirectory() throws Exception {
        Path toUpload = new File(PodUpload.class.getResource("/upload").getFile()).toPath();
        this.uploadDirectoryAndVerify(() -> PodUpload.upload((PodOperationsImpl)this.operation, (Path)toUpload));
    }

    @Test
    void upload_withDirectoryAndLongFileNames_shouldUploadDirectory() throws Exception {
        Path toUpload = new File(PodUpload.class.getResource("/upload_long").getFile()).toPath();
        this.uploadDirectoryAndVerify(() -> PodUpload.upload((PodOperationsImpl)this.operation, (Path)toUpload));
    }

    @Test
    void transferTo() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("I'LL BE COPIED".getBytes(Charset.defaultCharset()));
        AtomicReference copiedStream = new AtomicReference();
        InputStreamPumper.Writable consumer = (bytes, offset, length) -> {
            Assertions.assertThat((int)length).isEqualTo(14);
            copiedStream.set(new String(Arrays.copyOf(bytes, 14), Charset.defaultCharset()));
        };
        InputStreamPumper.transferTo((InputStream)input, (InputStreamPumper.Writable)consumer);
        Assertions.assertThat(copiedStream).hasValue((Object)"I'LL BE COPIED");
    }

    @Test
    void createExecCommandForUpload_withFileInRootPath_shouldCreateValidExecCommandForUpload() {
        String result = PodUpload.createExecCommandForUpload((String)"/cp.log");
        Assertions.assertThat((String)result).isEqualTo("mkdir -p '/' && base64 -d - > '/cp.log'");
    }

    @Test
    void createExecCommandForUpload_withNormalFile_shouldCreateValidExecCommandForUpload() {
        String result = PodUpload.createExecCommandForUpload((String)"/tmp/foo/cp.log");
        Assertions.assertThat((String)result).isEqualTo("mkdir -p '/tmp/foo' && base64 -d - > '/tmp/foo/cp.log'");
    }

    @Test
    void createExecCommandForUpload_withSingleQuoteInPath() {
        String result = PodUpload.createExecCommandForUpload((String)"/tmp/fo'o/cp.log");
        Assertions.assertThat((String)result).isEqualTo("mkdir -p '/tmp/fo'\\''o' && base64 -d - > '/tmp/fo'\\''o/cp.log'");
    }

    @Test
    void createExecCommandForUpload_withMultipleSingleQuotesInPath() {
        String result = PodUpload.createExecCommandForUpload((String)"/tmp/f'o'o/c'p.log");
        Assertions.assertThat((String)result).isEqualTo("mkdir -p '/tmp/f'\\''o'\\''o' && base64 -d - > '/tmp/f'\\''o'\\''o/c'\\''p.log'");
    }

    void uploadFileAndVerify(PodUploadTester<Boolean> fileUploadMethodToTest) throws IOException, InterruptedException {
        this.operation = this.operation.file("/mock/dir/file");
        WebSocket.Builder builder = (WebSocket.Builder)Mockito.mock(WebSocket.Builder.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)builder.buildAsync((WebSocket.Listener)ArgumentMatchers.any())).thenAnswer(newWebSocket -> {
            ExecWebSocketListener wsl = (ExecWebSocketListener)newWebSocket.getArgument(0, ExecWebSocketListener.class);
            wsl.onOpen(this.mockWebSocket);
            wsl.onMessage(this.mockWebSocket, ByteBuffer.wrap(new byte[]{0}));
            ((WebSocket)Mockito.doAnswer(close -> {
                wsl.onClose(this.mockWebSocket, ((Integer)close.getArgument(0)).intValue(), (String)close.getArgument(1));
                return null;
            }).when((Object)this.mockWebSocket)).sendClose(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
            return CompletableFuture.completedFuture(this.mockWebSocket);
        });
        Mockito.when((Object)this.mockClient.newWebSocketBuilder()).thenReturn((Object)builder);
        boolean result = fileUploadMethodToTest.apply();
        Assertions.assertThat((boolean)result).isTrue();
        ((WebSocket.Builder)Mockito.verify((Object)builder, (VerificationMode)Mockito.times((int)1))).uri((URI)ArgumentMatchers.argThat(request -> {
            Assertions.assertThat((URI)request).hasToString("https://openshift.com:8443/api/v1/namespaces/default/pods/exec?command=sh&command=-c&command=mkdir%20-p%20%27%2Fmock%2Fdir%27%20%26%26%20base64%20-d%20-%20%3E%20%27%2Fmock%2Fdir%2Ffile%27&container=container&stdin=true&stderr=true");
            return true;
        }));
        ((WebSocket)Mockito.verify((Object)this.mockWebSocket, (VerificationMode)Mockito.atLeast((int)1))).send((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    private void uploadDirectoryAndVerify(PodUploadTester<Boolean> directoryUpload) throws IOException, InterruptedException {
        this.operation = this.operation.dir("/mock/dir");
        WebSocket.Builder builder = (WebSocket.Builder)Mockito.mock(WebSocket.Builder.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)builder.buildAsync((WebSocket.Listener)ArgumentMatchers.any())).thenAnswer(newWebSocket -> {
            ExecWebSocketListener wsl = (ExecWebSocketListener)newWebSocket.getArgument(0, ExecWebSocketListener.class);
            wsl.onOpen(this.mockWebSocket);
            wsl.onMessage(this.mockWebSocket, ByteBuffer.wrap(new byte[]{0}));
            ((WebSocket)Mockito.doAnswer(close -> {
                wsl.onClose(this.mockWebSocket, ((Integer)close.getArgument(0)).intValue(), (String)close.getArgument(1));
                return null;
            }).when((Object)this.mockWebSocket)).sendClose(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
            return CompletableFuture.completedFuture(this.mockWebSocket);
        });
        Mockito.when((Object)this.mockClient.newWebSocketBuilder()).thenReturn((Object)builder);
        boolean result = directoryUpload.apply();
        Assertions.assertThat((boolean)result).isTrue();
        ((WebSocket.Builder)Mockito.verify((Object)builder, (VerificationMode)Mockito.times((int)1))).uri((URI)ArgumentMatchers.argThat(request -> {
            Assertions.assertThat((URI)request).hasToString("https://openshift.com:8443/api/v1/namespaces/default/pods/exec?command=sh&command=-c&command=mkdir%20-p%20%27%2Fmock%2Fdir%27%20%26%26%20base64%20-d%20-%20%7C%20tar%20-C%20%27%2Fmock%2Fdir%27%20-xzf%20-&container=container&stdin=true&stderr=true");
            return true;
        }));
        ((WebSocket)Mockito.verify((Object)this.mockWebSocket, (VerificationMode)Mockito.atLeast((int)1))).send((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @FunctionalInterface
    public static interface PodUploadTester<R> {
        public R apply() throws IOException, InterruptedException;
    }
}

