/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.dsl.internal.PortForwarderWebsocketListener;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.utils.CommonThreadPool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PortForwarderWebsocketListenerTest {
    private WebSocket webSocket;
    private ReadableByteChannel in;
    private WritableByteChannel out;
    private ByteArrayOutputStream outputContent;
    private PortForwarderWebsocketListener listener;

    PortForwarderWebsocketListenerTest() {
    }

    @BeforeEach
    void setUp() {
        this.webSocket = (WebSocket)Mockito.mock(WebSocket.class);
        this.in = Channels.newChannel(new ByteArrayInputStream("THIS IS A TEST".getBytes(StandardCharsets.UTF_8)));
        this.outputContent = new ByteArrayOutputStream();
        this.out = Channels.newChannel(this.outputContent);
    }

    @AfterEach
    void tearDown() throws IOException {
        if (this.listener != null) {
            this.listener.onClose(null, 1337, "Test ended");
        }
        this.out.close();
        this.outputContent.close();
        this.in.close();
    }

    @Test
    void onOpen_shouldPipeInChannelToWebSocket() {
        this.listener = new PortForwarderWebsocketListener(this.in, this.out, (Executor)CommonThreadPool.get());
        this.listener.onOpen(this.webSocket);
        ArgumentCaptor contentTypeCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
        ((WebSocket)Mockito.verify((Object)this.webSocket, (VerificationMode)Mockito.timeout((long)10000L).times(1))).send((ByteBuffer)contentTypeCaptor.capture());
        Assertions.assertThat((Comparable)((Comparable)contentTypeCaptor.getValue())).extracting(StandardCharsets.UTF_8::decode).extracting(CharBuffer::toString).asString().startsWith((CharSequence)"THIS IS A TEST");
        Assertions.assertThat((boolean)this.in.isOpen()).isTrue();
        Assertions.assertThat((boolean)this.out.isOpen()).isTrue();
    }

    @Test
    void onOpen_withException_shouldCloseWebSocketAndStoreException() throws IOException {
        ReadableByteChannel inWithException = (ReadableByteChannel)Mockito.mock(ReadableByteChannel.class);
        Mockito.when((Object)inWithException.read((ByteBuffer)ArgumentMatchers.any())).thenThrow(new Throwable[]{new IOException("Error reading packets")});
        this.listener = new PortForwarderWebsocketListener(inWithException, this.out, (Executor)CommonThreadPool.get());
        this.listener.onOpen(this.webSocket);
        ((WebSocket)Mockito.verify((Object)this.webSocket, (VerificationMode)Mockito.timeout((long)10000L).times(1))).sendClose(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        ((AbstractThrowableAssert)((ObjectAssert)Assertions.assertThat((Collection)this.listener.getClientThrowables()).singleElement()).asInstanceOf(InstanceOfAssertFactories.throwable(IOException.class))).hasMessage("Error reading packets");
    }

    @Test
    void onError_shouldStoreExceptionAndCloseChannels() {
        this.listener = new PortForwarderWebsocketListener(this.in, this.out, (Executor)CommonThreadPool.get());
        this.listener.onError(this.webSocket, (Throwable)new RuntimeException("Server error"));
        ((AbstractThrowableAssert)((ObjectAssert)Assertions.assertThat((Collection)this.listener.getServerThrowables()).singleElement()).asInstanceOf(InstanceOfAssertFactories.throwable(RuntimeException.class))).hasMessage("Server error");
        Assertions.assertThat((boolean)this.in.isOpen()).isFalse();
        Assertions.assertThat((boolean)this.out.isOpen()).isFalse();
    }

    @Test
    void onClose_shouldCloseChannels() {
        this.listener = new PortForwarderWebsocketListener(this.in, this.out, (Executor)CommonThreadPool.get());
        this.listener.onClose(this.webSocket, 1337, "Test ended");
        Assertions.assertThat((Collection)this.listener.getServerThrowables()).isEmpty();
        Assertions.assertThat((boolean)this.in.isOpen()).isFalse();
        Assertions.assertThat((boolean)this.out.isOpen()).isFalse();
    }

    @Test
    void onMessage_shouldSkipTwoMessagesAndPipeTheThird() {
        this.listener = new PortForwarderWebsocketListener(this.in, this.out, (Executor)CommonThreadPool.get());
        ((WebSocket)Mockito.doAnswer(i -> {
            this.listener.onMessage(this.webSocket, "SKIP 2");
            return true;
        }).doAnswer(i -> {
            this.listener.onMessage(this.webSocket, ByteBuffer.wrap(ByteBuffer.allocate(18).put((byte)0).put("PROCESSED MESSAGE".getBytes(StandardCharsets.UTF_8)).array()));
            return true;
        }).doNothing().when((Object)this.webSocket)).request();
        this.listener.onMessage(this.webSocket, "SKIP 1");
        ((WebSocket)Mockito.verify((Object)this.webSocket, (VerificationMode)Mockito.timeout((long)10000L).times(3))).request();
        Assertions.assertThat((String)this.outputContent.toString()).contains(new CharSequence[]{"PROCESSED MESSAGE"});
    }

    @Test
    void onMessage_withEmptyMessage_shouldEndWithError() {
        this.listener = new PortForwarderWebsocketListener(this.in, this.out, (Executor)CommonThreadPool.get());
        ((WebSocket)Mockito.doAnswer(i -> {
            this.listener.onMessage(this.webSocket, "SKIP 2");
            return true;
        }).doAnswer(i -> {
            this.listener.onMessage(this.webSocket, ByteBuffer.wrap(new byte[0]));
            return true;
        }).when((Object)this.webSocket)).request();
        this.listener.onMessage(this.webSocket, "SKIP 1");
        ((WebSocket)Mockito.verify((Object)this.webSocket, (VerificationMode)Mockito.timeout((long)10000L))).sendClose(1002, "Protocol error");
        Assertions.assertThat((String)this.outputContent.toString()).isEmpty();
        Assertions.assertThat((boolean)this.listener.errorOccurred()).isTrue();
        Assertions.assertThat((Collection)this.listener.getServerThrowables()).isEmpty();
        Assertions.assertThat((boolean)this.in.isOpen()).isFalse();
        Assertions.assertThat((boolean)this.out.isOpen()).isFalse();
    }

    @Test
    void onMessage_withServerClose_shouldSkipTwoMessagesAndPipeTheThird() {
        this.listener = new PortForwarderWebsocketListener(this.in, this.out, (Executor)CommonThreadPool.get());
        ((WebSocket)Mockito.doAnswer(i -> {
            this.listener.onMessage(this.webSocket, "SKIP 2");
            return true;
        }).doAnswer(i -> {
            this.listener.onMessage(this.webSocket, ByteBuffer.wrap(ByteBuffer.allocate(18).put((byte)0).put("PROCESSED MESSAGE".getBytes(StandardCharsets.UTF_8)).array()));
            return true;
        }).doAnswer(i -> {
            this.listener.onClose(this.webSocket, 31337, "Transmission complete");
            return true;
        }).when((Object)this.webSocket)).request();
        this.listener.onMessage(this.webSocket, "SKIP 1");
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> !this.listener.isAlive());
        Assertions.assertThat((String)this.outputContent.toString()).contains(new CharSequence[]{"PROCESSED MESSAGE"});
        Assertions.assertThat((boolean)this.listener.errorOccurred()).isFalse();
        Assertions.assertThat((boolean)this.in.isOpen()).isFalse();
        Assertions.assertThat((boolean)this.out.isOpen()).isFalse();
    }

    @Test
    void onMessage_withWrongChannel_shouldLogAndEndWithError() {
        try (MockedStatic loggerFactory = Mockito.mockStatic(LoggerFactory.class);){
            Logger logger = (Logger)Mockito.mock(Logger.class);
            loggerFactory.when(() -> LoggerFactory.getLogger(PortForwarderWebsocketListener.class)).thenReturn((Object)logger);
            this.listener = new PortForwarderWebsocketListener(this.in, this.out, (Executor)CommonThreadPool.get());
            ((WebSocket)Mockito.doAnswer(i -> {
                this.listener.onMessage(this.webSocket, "SKIP 2");
                return true;
            }).doAnswer(i -> {
                this.listener.onMessage(this.webSocket, ByteBuffer.wrap(ByteBuffer.allocate(18).put((byte)5).put("WRONG CHANNEL".getBytes(StandardCharsets.UTF_8)).array()));
                return true;
            }).doNothing().when((Object)this.webSocket)).request();
            this.listener.onMessage(this.webSocket, "SKIP 1");
            ((WebSocket)Mockito.verify((Object)this.webSocket, (VerificationMode)Mockito.timeout((long)10000L))).sendClose(1002, "Protocol error");
            Assertions.assertThat((String)this.outputContent.toString()).isEmpty();
            Assertions.assertThat((boolean)this.listener.errorOccurred()).isTrue();
            ((Logger)Mockito.verify((Object)logger)).error("Received a wrong channel from the remote socket: {}", (Object)5);
        }
    }
}

