/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.DefaultKubernetesResourceList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.impl.KubernetesClientImpl;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class HasMetadataOperationsImplTest {
    HasMetadataOperationsImplTest() {
    }

    @Test
    void shouldBeAbleToReturnOperationsWithoutSpecificList() {
        MixedOperation operation = new KubernetesClientImpl().resources(Bar.class, BarList.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)operation);
    }

    @Test
    void shouldReturnGenericKubernetesResourceWhenNotRegistered() {
        KubernetesResource resource = (KubernetesResource)Serialization.unmarshal((String)"{\n    \"apiVersion\": \"sample.fabric8.io/v1\",\n    \"kind\": \"Bar\"\n}");
        ((ObjectAssert)Assertions.assertThat((Object)resource).isInstanceOf(GenericKubernetesResource.class)).hasFieldOrPropertyWithValue("apiVersion", (Object)"sample.fabric8.io/v1");
    }

    public static class BarList
    extends DefaultKubernetesResourceList<Bar> {
    }

    @Group(value="sample.fabric8.io")
    @Version(value="v1")
    public static class Bar
    extends CustomResource<Object, Object> {
    }
}

