/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.internal;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.internal.OptionalDependencyWrapper;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OptionalDependencyWrapperTest {
    OptionalDependencyWrapperTest() {
    }

    @Test
    void testWrapRunWithOptionalDependencyHasAllDependenciesShouldNotThrowException() {
        boolean result = (Boolean)OptionalDependencyWrapper.wrapRunWithOptionalDependency(() -> true, (String)"I have no optional dependencies");
        Assert.assertThat((Object)result, (Matcher)IsEqual.equalTo((Object)true));
    }

    @Test
    void testWrapRunWithOptionalDependencyUsesDependencyShouldThrowException() {
        KubernetesClientException exception = (KubernetesClientException)Assertions.assertThrows(KubernetesClientException.class, () -> OptionalDependencyWrapper.wrapRunWithOptionalDependency(() -> {
            throw new NoClassDefFoundError("com.1337.invalid.IDontExist");
        }, (String)"IDontExist class is provided by some optional package"));
        Assert.assertThat((Object)exception.getMessage(), (Matcher)IsEqual.equalTo((Object)"IDontExist class is provided by some optional package, an optional dependency. To use this functionality you must explicitly add this dependency to the classpath."));
    }
}

