/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.impl.cache;

import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.api.model.PodListFluent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.informers.impl.ListerWatcher;
import io.fabric8.kubernetes.client.informers.impl.cache.Reflector;
import io.fabric8.kubernetes.client.informers.impl.cache.SyncableStore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ReflectorTest {
    ReflectorTest() {
    }

    @Test
    void testStateFlags() {
        ListerWatcher mock = (ListerWatcher)Mockito.mock(ListerWatcher.class);
        PodList list = ((PodListBuilder)((PodListFluent.MetadataNested)new PodListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).build();
        Mockito.when((Object)mock.submitList((ListOptions)Mockito.any())).thenReturn(CompletableFuture.completedFuture(list));
        Reflector<Pod, PodList> reflector = new Reflector<Pod, PodList>(mock, (SyncableStore)Mockito.mock(SyncableStore.class)){

            protected void reconnect() {
            }
        };
        reflector.setExceptionHandler((b, t) -> true);
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assertions.assertFalse((boolean)reflector.isStopped());
        Mockito.when((Object)mock.submitWatch((ListOptions)Mockito.any(), (Watcher)Mockito.any())).thenThrow(new Throwable[]{new KubernetesClientException("error")}).thenReturn(CompletableFuture.completedFuture(Mockito.mock(Watch.class)));
        CompletableFuture future = reflector.start();
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assertions.assertFalse((boolean)reflector.isStopped());
        reflector.listSyncAndWatch().join();
        Assertions.assertTrue((boolean)reflector.isWatching());
        Assertions.assertFalse((boolean)reflector.isStopped());
        Assertions.assertFalse((boolean)reflector.getStopFuture().isDone());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((!future.isCompletedExceptionally() ? 1 : 0) != 0);
        reflector.stop();
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assertions.assertTrue((boolean)reflector.isStopped());
        Assertions.assertTrue((boolean)reflector.getStopFuture().isDone());
    }

    @Test
    void testNotRunningAfterStartError() {
        ListerWatcher mock = (ListerWatcher)Mockito.mock(ListerWatcher.class);
        PodList list = ((PodListBuilder)((PodListFluent.MetadataNested)new PodListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).build();
        Mockito.when((Object)mock.submitList((ListOptions)Mockito.any())).thenReturn(CompletableFuture.completedFuture(list));
        Reflector reflector = new Reflector(mock, (SyncableStore)Mockito.mock(SyncableStore.class));
        Mockito.when((Object)mock.submitWatch((ListOptions)Mockito.any(), (Watcher)Mockito.any())).thenThrow(new Throwable[]{new KubernetesClientException("error")});
        CompletableFuture future = reflector.start();
        Assertions.assertThrows(CompletionException.class, future::join);
        Assertions.assertTrue((boolean)reflector.isStopped());
    }

    @Test
    void testNonHttpGone() {
        ListerWatcher mock = (ListerWatcher)Mockito.mock(ListerWatcher.class);
        PodList list = ((PodListBuilder)((PodListFluent.MetadataNested)new PodListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).build();
        Mockito.when((Object)mock.submitList((ListOptions)Mockito.any())).thenReturn(CompletableFuture.completedFuture(list));
        Reflector reflector = new Reflector(mock, (SyncableStore)Mockito.mock(SyncableStore.class));
        Mockito.when((Object)mock.submitWatch((ListOptions)Mockito.any(), (Watcher)Mockito.any())).thenReturn(CompletableFuture.completedFuture(Mockito.mock(Watch.class)));
        reflector.start();
        Assertions.assertTrue((boolean)reflector.isWatching());
        Assertions.assertFalse((boolean)reflector.isStopped());
        reflector.getWatcher().onClose(new WatcherException(null));
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assertions.assertTrue((boolean)reflector.isStopped());
    }
}

