/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.impl;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.impl.KubernetesClientImpl;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class KubernetesClientImplTest {
    private static final String TEST_CONFIG_YML_FILE = Utils.filePath((URL)KubernetesClientImplTest.class.getResource("/test-config.yml"));
    private KubernetesClientImpl defaultKubernetesClient;

    KubernetesClientImplTest() {
    }

    @BeforeEach
    public void setUp() {
        this.defaultKubernetesClient = new KubernetesClientImpl();
    }

    @AfterEach
    public void tearDown() {
        this.defaultKubernetesClient.close();
        this.defaultKubernetesClient = null;
    }

    @Test
    void testInitClientWithCustomHeaderConfiguration() {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        customHeaders.put("user-id", "test-user");
        customHeaders.put("cluster-id", "test-cluster");
        Config configWithCustomerHeaders = ((ConfigBuilder)new ConfigBuilder().withCustomHeaders(customHeaders)).build();
        BasicBuilder basicBuilder = (BasicBuilder)Mockito.mock(BasicBuilder.class);
        ((Interceptor)HttpClientUtils.createApplicableInterceptors((Config)configWithCustomerHeaders, null).get("HEADER")).before(basicBuilder, (HttpHeaders)Mockito.mock(HttpHeaders.class));
        ((BasicBuilder)Mockito.verify((Object)basicBuilder, (VerificationMode)Mockito.times((int)1))).header("user-id", "test-user");
    }

    @Test
    void testInitClientWithDefaultConfiguration() {
        Config defaultEmptyConfig = new ConfigBuilder().build();
        BasicBuilder basicBuilder = (BasicBuilder)Mockito.mock(BasicBuilder.class);
        ((Interceptor)HttpClientUtils.createApplicableInterceptors((Config)defaultEmptyConfig, null).get("HEADER")).before(basicBuilder, (HttpHeaders)Mockito.mock(HttpHeaders.class));
        ((BasicBuilder)Mockito.verify((Object)basicBuilder, (VerificationMode)Mockito.never())).header("user-id", "test-user");
    }

    @Test
    @DisplayName(value="load, InputStream containing List with windows like line-ends (CRLF), all list items should be available")
    void loadWithWindowsLineSeparatorsString() throws Exception {
        List<String> fileLines = Files.readAllLines(new File(KubernetesClientImplTest.class.getResource("/test-list.yml").getFile()).toPath(), StandardCharsets.UTF_8);
        String crlfFile = String.join((CharSequence)" \r\n", fileLines);
        List result = (List)new KubernetesClientImpl().load((InputStream)new ByteArrayInputStream(crlfFile.getBytes(StandardCharsets.UTF_8))).get();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)result).hasSize(2)).hasAtLeastOneElementOfType(Service.class)).hasAtLeastOneElementOfType(Deployment.class);
    }

    @Test
    void shouldInstantiateClientUsingYaml() {
        File configYml = new File(TEST_CONFIG_YML_FILE);
        try (FileInputStream is = new FileInputStream(configYml);){
            KubernetesClientImpl client = KubernetesClientImpl.fromConfig((InputStream)is);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"http://some.url/", (Object)client.getMasterUrl().toString());
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail();
        }
    }

    @Test
    void shouldInstantiateClientUsingSerializeDeserialize() {
        KubernetesClientImpl original = new KubernetesClientImpl();
        String json = Serialization.asJson((Object)original.getConfiguration());
        KubernetesClientImpl copy = KubernetesClientImpl.fromConfig((String)json);
        org.junit.jupiter.api.Assertions.assertEquals((Object)original.getConfiguration().getMasterUrl(), (Object)copy.getConfiguration().getMasterUrl());
        org.junit.jupiter.api.Assertions.assertEquals((Object)original.getConfiguration().getOauthToken(), (Object)copy.getConfiguration().getOauthToken());
        org.junit.jupiter.api.Assertions.assertEquals((Object)original.getConfiguration().getNamespace(), (Object)copy.getConfiguration().getNamespace());
        org.junit.jupiter.api.Assertions.assertEquals((Object)original.getConfiguration().getUsername(), (Object)copy.getConfiguration().getUsername());
        org.junit.jupiter.api.Assertions.assertEquals((Object)original.getConfiguration().getPassword(), (Object)copy.getConfiguration().getPassword());
    }

    @Test
    void shouldPropagateImpersonateSettings() {
        HashMap<String, List<String>> extras = new HashMap<String, List<String>>();
        extras.put("c", Collections.singletonList("d"));
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withImpersonateUsername("a")).withImpersonateGroups(new String[]{"b"})).withImpersonateExtras(extras)).build();
        KubernetesClientImpl client = new KubernetesClientImpl(config);
        Config currentConfig = client.getConfiguration();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)currentConfig.getImpersonateUsername());
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])new String[]{"b"}, (Object[])currentConfig.getImpersonateGroups());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList("d"), currentConfig.getImpersonateExtras().get("c"));
    }
}

